% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eff_dmus.R
\name{eff_dmus}
\alias{eff_dmus}
\title{Efficient DMUs.}
\usage{
eff_dmus(deasol, tol = 1e-04)
}
\arguments{
\item{deasol}{An object of class \code{"dea"} obtained by a DEA model function.}

\item{tol}{Numeric. Absolute tolerance for numeric comparisons in efficiency scores.
By default, it is 1e-4.}
}
\value{
A numeric vector containing which DMUs has been evaluated as efficient.
This vector is empty if there is not any efficient DMU.
}
\description{
Returns the efficient DMUs evaluated in a \code{dea} class object.
}
\note{
If \code{maxslack} is \code{FALSE}, the slacks computed in the first stage
are supposed to be the max slacks.
}
\examples{
dataFortune <- make_deadata(Fortune500,
                            ni = 3,
                            no = 2)
ccrFortune <- model_basic(dataFortune)
eff_dmus(ccrFortune)

}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
