% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_mcmc.R
\name{debinfer_par}
\alias{debinfer_par}
\title{debinfer_par}
\usage{
debinfer_par(
  name,
  var.type,
  fixed,
  value,
  joint = NULL,
  prior = NULL,
  hypers = NULL,
  prop.var = NULL,
  samp.type = NULL
)
}
\arguments{
\item{name}{character vector; name of the variable}

\item{var.type}{character vector; type of the variable "de" = parameter for the differential equation, "obs" = parameter of the observation model, "init" = initial condition for a state variable in the differential equation}

\item{fixed}{boolean; TRUE = parameter is taken to be fixed, FALSE = parameter is to be estimated by MCMC}

\item{value}{numeric; parameter value. For fixed parameters this is the value used in the analysis for free parameters this is the starting value used when setting up the MCMC chain}

\item{joint}{integer; number of block for joint proposal; NULL means the parameter is not to be jointly proposed}

\item{prior}{character; name of the probability distribution for the prior on the parameter. Must conform to standard R naming of d/r function pairs, e.g. beta ( foo = beta), binomial binom, Cauchy cauchy, chi-squared chisq, exponential exp, Fisher F f, gamma gamma, geometric geom, hypergeometric hyper, logistic logis, lognormal lnorm, negative binomial nbinom, normal norm, Poisson pois, Student t t, uniform unif, Weibull weibull. Priors from the truncdist package are available by default. User priors can be provided but must be available in the environment from which de_mcmc is called.}

\item{hypers}{list of numeric vectors, hyperparameters for the prior; mean only for mvnorm. Can include trunc for truncated pdfs from package truncdist.}

\item{prop.var}{numeric; tuning parameters. For Normal proposals (`samp.type="rw"` or `samp.type="rw-ref"`), this must be a positive number representing the standard deviation of the proposal distribution for each parameter. For the asymmetric uniform proposal distribution (`samp.type="rw-unif"`) two positive numeric values are required and the proposal will then have the bounds `prop.var[1]/prop.var[2]*current_proposal` and `prop.var[2]/prop.var[1]*current_proposal`. See Boersch-Supan et al. (2016).}

\item{samp.type}{character; type of sampler: "rw" = Normal random walk, "ind" = independence, "rw-unif" = asymmetric uniform distribution, "rw-ref" = reflecting random walk sampler on the bounds of the prior support (cf. Hoff 2009, Chapter 10.5.1; Yang and Rodriguez 2013)}
}
\value{
returns an object of class debinfer_par to be fed to the mcmc setup function
}
\description{
Creates an object containing all the necessary bits for a parameter i.e. initial values, prior distributions,
hyper-parameters, tuning parameters, etc. to set up a debinfer analysis
}
\references{
Boersch-Supan et al. 2016, MEE 8:511-518 \doi{10.1111/2041-210X.12679}

            Hoff 2009, A First Course in Bayesian Statistical Methods, Springer

            Yang and Rodriguez 2013, PNAS 110:19307-19312 \doi{10.1073/pnas.1311790110}
}
