% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.summary.ddt_lcm}
\alias{plot.summary.ddt_lcm}
\title{Plot the MAP tree and class profiles of summarized DDT-LCM results}
\usage{
\method{plot}{summary.ddt_lcm}(
  x,
  log = TRUE,
  plot_option = c("all", "profile", "tree"),
  item_name_list = NULL,
  color_palette = c("#E69F00", "#56B4E9", "#009E73", "#000000", "#0072B2", "#D55E00",
    "#CC79A7", "#F0E442", "#999999"),
  ...
)
}
\arguments{
\item{x}{a "summary.ddt_lcm" object}

\item{log}{Default argument passed to plot(). Not used.}

\item{plot_option}{option to select which part of the plot to return. If "all", return
the plot of MAP tree on the left and the plot of class profiles on the right. If "profile",
only return the plot of class profiles. If "tree", only return the plot of MAP tree.}

\item{item_name_list}{a named list of G elements, where the g-th element contains a vector
of item names for items in \code{item_membership_list[[g]]}. The name of the g-th element is
the name of the major item group.}

\item{color_palette}{a vector of color names. Default is a color-blinded friendly palette.}

\item{\dots}{Further arguments passed to each method}
}
\value{
a ggplot2 object. If plot_option is "all", then a plot with maximum a posterior
tree structure on the left and a bar plot of item response probabilities (with 95\%
credible intervals and class probabilities) on the right. If plot_option is
"profile", then only a bar plot of item response probabilities. If plot_option is
"tree", then only a plot of the tree structure.
}
\description{
Plot the MAP tree and class profiles of summarized DDT-LCM results
}
\examples{
data(result_hchs)
burnin <- 50
summarized_result <- summary(result_hchs, burnin, relabel = TRUE, be_quiet = TRUE)
plot(x = summarized_result, item_name_list = NULL, plot_option = "all")
}
