% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.ddsPLS.R
\name{summary.ddsPLS}
\alias{summary.ddsPLS}
\title{Function to sum up bootstrap performance results of the ddsPLS algorithm}
\usage{
\method{summary}{ddsPLS}(object, returnValues = FALSE, digits = 2, ...)
}
\arguments{
\item{object}{A ddsPLS object.}

\item{returnValues}{boolean. Wether or not to return the printed values, default to FALSE.}

\item{digits}{integer indicating the number of decimal places (round) to be used.}

\item{\ldots}{arguments to be passed to methods, such as graphical parameters.}
}
\value{
No return value, called for side effects
}
\description{
Function to sum up bootstrap performance results of the ddsPLS algorithm
}
\examples{
n <- 100 ; d <- 2 ; p <- 20 ; q <- 2
phi <- matrix(rnorm(n*d),n,d)
a <- rep(1,p/4) ; b <- rep(1,p/2)
X <- phi\%*\%matrix(c(1*a,0*a,0*b,1*a,3*b,0*a),nrow = d,byrow = TRUE) +
matrix(rnorm(n*p,sd = 1/4),n,p)
Y <- phi\%*\%matrix(c(1,0,0,0),nrow = d,byrow = TRUE) +
matrix(rnorm(n*q,sd = 1/4),n,q)
res <- ddsPLS(X,Y,verbose=FALSE)
summary(res,digits=5)

}
\seealso{
\code{\link{ddsPLS}}, \code{\link{plot.ddsPLS}}, \code{\link{predict.ddsPLS}}
}
