% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddspls.R
\name{ddsPLS}
\alias{ddsPLS}
\title{Data-Driven Sparse Partial Least Squares}
\usage{
ddsPLS(
  X,
  Y,
  criterion = "diffR2Q2",
  doBoot = TRUE,
  LD = FALSE,
  lambdas = NULL,
  n_B = 50,
  n_lambdas = 100,
  lambda_roof = NULL,
  lowQ2 = 0,
  NCORES = 1,
  errorMin = 1e-09,
  verbose = FALSE
)
}
\arguments{
\item{X}{matrix, the covariate matrix (n,p).}

\item{Y}{matrix, the response matrix (n,q).}

\item{criterion}{character, whether \code{diffR2Q2} to be minimized, default,
or \code{Q2} to be maximized.}

\item{doBoot}{logical, whether performing bootstrap operations, default to
\code{TRUE}. If equal to
\code{FALSE}, a model with is built on the parameters \code{lambda} and the
 number of components is the length of this vector.
  In that context, the parameter \code{n_B} is ignored. If equal to
   \code{TRUE}, the ddsPLS algorithm, through bootstrap validation,
    is started using \code{lambda} as a grid and \code{n_B} as
  the total number of bootstrap samples to simulate per component.}

\item{LD}{boolean. Wether or not to consider low dimensional dataset. If
sequal to \code{TRUE}, no low value is estimated for \code{lambda} (\code{lambda0}=0). Else,
\code{lambda} is estimated thanks to in order to prevent from including too
much variables in the current component.}

\item{lambdas}{vector, the to be tested values for \code{lambda}.
Each value for \code{lambda} can be interpreted in terms of correlation
 allowed in the model.
More precisely, a covariate `x[j]` is not selected if its empirical
correlation with all the response variables `y[1..q]` is below \code{lambda}.
 A response variable `y[k]` is not selected if its empirical correlation
 with all the covariates `x[1..p]` is below \code{lambda}.
Default to \code{seq(0,1,length.out = 30)}.}

\item{n_B}{integer, the number of to be simulated bootstrap samples.
Default to \code{50}.}

\item{n_lambdas}{integer, the number of lambda values. Taken into account
only if \code{lambdas} is \code{NULL}. Default to 100.}

\item{lambda_roof}{real, the maximum value to be tested by the algorithm for
\code{lambda}. This is automatically fixed by the algorithm.}

\item{lowQ2}{real, the minimum value of Q^2_B to accept the
current lambda value. Default to \code{0.0}.}

\item{NCORES}{integer, the number of cores used. Default to \code{1}.}

\item{errorMin}{real, not to be used.}

\item{verbose}{boolean, whether to print current results. Defaut to
\code{FALSE}.}
}
\value{
\item{model}{a list containing the PLS parameters:}
\itemize{
  \item \code{$P}: Loadings for \code{X}.
  \item \code{$C}: Loadings for \code{Y}.
  \item \code{$t}: Scores.
  \item \code{$V}: Weights for \code{Y}.
  \item \code{$U}: Loadings for \code{X}.
  \item \code{$U_star}: Loadings for \code{X} in original base: $U_star=U(P'U)^{-1}$.
  \item \code{$B}: Regression matrix of \code{Y} on \code{X}.
  \item \code{$muY}: Empirical mean of \code{Y}.
  \item \code{$muX}: Empirical mean of \code{X}.
  \item \code{$sdY}: Empirical standard deviation of \code{Y}.
  \item \code{$sdX}: Empirical standard deviation of \code{X}.
}
\item{results}{a list containing the ddsPLS descriptors after bootstrap
operations:}
\itemize{
    \item \code{$PropQ2hPos}: A list of size \code{R}+1 where \code{R} is the
    evaluated number of components. Each element is a vector of length
    \code{n_lambdas}. Each value is the proportion of times the \code{Q2h}
    statistics is positive among the \code{n_B} estimated ddsPLS models.
    \item \code{$Q2h}:  A list of size \code{R}+1 where \code{R} is the
    evaluated number of components. Each element is a
    \code{(n_B,n_lambdas)}-matrix. Each value is the value for the statistics
     \code{Q2h}.
    \item \code{$Q2}: :  A list of size \code{R}+1 where \code{R} is the
    evaluated number of components. Each element is a
    \code{(n_B,n_lambdas)}-matrix. Each value is the value for the statistics
     \code{Q2}.
    \item \code{$R2h}: :  A list of size \code{R}+1 where \code{R} is the
    evaluated number of components. Each element is a
    \code{(n_B,n_lambdas)}-matrix. Each value is the value for the statistics
     \code{R2h}.
    \item \code{$R2}: :  A list of size \code{R}+1 where \code{R} is the
    evaluated number of components. Each element is a
    \code{(n_B,n_lambdas)}-matrix. Each value is the value for the statistics
     \code{R2}.
    \item \code{$V}: Empirical means and variances of the weights for
    \code{Y} for each component.
    \item \code{$U}: Empirical means and variances of the weights for
    \code{X} for each component.
    \item \code{$U_star}: Empirical means and variances of the loadings for
    \code{X} in original base for each component.
    \item \code{$C}: Empirical means and variances of the loadings for
    \code{Y} for each component.
    \item \code{$P}: Empirical means and variances of the loadings for
    \code{X} for each component.
    \item \code{$t}: Empirical means and variances of the score for each
    component.
    \item \code{$R2mean_diff_Q2mean}: Differences of the empirical means of
    the statistics R2 and Q2.
    \item \code{$Q2hmean}: Empirical means of the statistic Q2h.
    \item \code{$Q2mean}: Empirical means of the statistic Q2.
    \item \code{$R2hmean}: Empirical means of the statistic R2h.
    \item \code{$R2mean}: Empirical means of the statistic R2.
    \item \code{$R2sd}: Empirical standard deviations of the statistic R2.
    \item \code{$R2hsd}: Empirical standard deviations of the statistic R2h.
    \item \code{$Q2sd}: Empirical standard deviations of the statistic Q2.
    \item \code{$Q2hsd}: Empirical standard deviations of the statistic Q2h.
    \item \code{$R2_diff_Q2sd}: Differences of the empirical standard
    deviations of the statistics R2 and Q2.
    \item \code{$lambdas}: Values tested for \code{lambdas}.
}
\item{varExplained_in_X}{a list containing the explained variances in
\code{X} per component (\code{Comp}) or cumulated (\code{Cumu}).}
\item{varExplained}{a list containing the explained variances in
\code{Y} per component (\code{Comp}), cumulated (\code{Cumu}), or per
dimension of \code{Y} separately. The three last objects detail the
explained variances per dimension of \code{Y} per component
(\code{PerYPerComp$Comp}) or cumulated (\code{PerYPerComp$Cumu}).}
\item{R}{The evaluated number of components.}
\item{lambda}{The \code{R} values evaluated for \code{lambda}.}
\item{lambda_optim}{a list containing 3 matrices with boolean values
corresponding to wether or not each to be tested value for \code{lambda} has
been indeed tested.}
\item{Q2, Q2h, R2, R2h}{vector. The \code{R} values evaluated for \code{Q2},
 \code{Q2h}, \code{R2} and \code{R2h}.}
 \item{lowQ2}{The input parameter of the same name.}
 \item{X}{The input parameter of the same name.}
 \item{doBoot}{The input parameter of the same name.}
 \item{Y_est}{The estimated values for the response variable.}
 \item{Y_obs}{The observed values for the response variable.}
 \item{Selection}{A list of two elements of the indices corresponding with
 the variables selected in \code{X} and in \code{Y}.}
 \item{call}{The call given to the function.}
 \item{criterion}{The input parameter of the same name.}
}
\description{
The main function of the package. It does both start the ddsPLS algorithm,
using bootstrap analysis. Also it estimates automatically the number of
components and the regularization coefficients.
One regularization parameter per component only is needed to select both in
\code{x} and in \code{y}. Build the optimal model, of the class
\code{ddsPLS}.
Among the different parameters, the \code{lambda} is the vector of parameters that are
tested by the algorithm along each component for each bootstrap sample. The total number
of bootstrap samples is fixed by the parameter \code{n_B}, for this parameter, the more
 the merrier, even if costs more in computation time.
This gives access to 3 S3 methods (\code{\link{summary.ddsPLS}}, \code{\link{plot.ddsPLS}} and \code{\link{predict.ddsPLS}}).
}
\examples{
n <- 100 ; d <- 2 ; p <- 20 ; q <- 2
phi <- matrix(rnorm(n*d),n,d)
a <- rep(1,p/4) ; b <- rep(1,p/2)
X <- phi\%*\%matrix(c(1*a,0*a,0*b,1*a,3*b,0*a),nrow = d,byrow = TRUE) +
matrix(rnorm(n*p,sd = 1/4),n,p)
Y <- phi\%*\%matrix(c(1,0,0,0),nrow = d,byrow = TRUE) +
matrix(rnorm(n*q,sd = 1/4),n,q)
res <- ddsPLS(X,Y,verbose=TRUE)

}
\seealso{
\code{\link{summary.ddsPLS}}, \code{\link{plot.ddsPLS}}, \code{\link{predict.ddsPLS}}
}
