% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perf_mddsPLS.R
\name{perf_mddsPLS}
\alias{perf_mddsPLS}
\title{Function to compute cross-validation performances.}
\usage{
perf_mddsPLS(Xs, Y, lambda_min = 0, lambda_max = NULL, n_lambda = 1,
  lambdas = NULL, R = 1, kfolds = "loo", mode = "reg",
  fold_fixed = NULL, maxIter_imput = 20, errMin_imput = 1e-09,
  NCORES = 1)
}
\arguments{
\item{Xs}{A matrix, if there is only one block, or a list of matrices,
if there is more than one block, of \emph{n} rows each, the number of individuals.
 Some rows must be missing. The different matrices can have different numbers of columns.
  The length of Xs is denoted by \emph{K}.}

\item{Y}{A matrix of n rows of a vector of length n detailing the
response matrix. No missing values are allowed in that matrix.}

\item{lambda_min}{A real in \eqn{[0,1]}. The minimum value considered.
Default is \eqn{0}.}

\item{lambda_max}{A real in \eqn{[0,1]}. The maximum value considered.
Default is \eqn{NULL}, interpreted to the largest correlation between
\emph{X} and \emph{Y}.}

\item{n_lambda}{A strictly positive integer. Default to \eqn{1}.}

\item{lambdas}{A vector of reals in \eqn{[0,1]}. The values tested by the
perf process. Default is \eqn{NULL}, when that parameter is not taken into account.}

\item{R}{A strictly positive integer detailing the number of components to
build in the model.}

\item{kfolds}{character or integer. If equals to "loo" then a \emph{leave-one-out}
cross-validation is started. No other character is understood. Any strictly
positive integer gives the number of folds to make in the \emph{cross-validation process}}

\item{mode}{A character chain. Possibilities are "\emph{reg}", which implies
regression problem or anything else which means clustering is considered.
 Default is "\emph{reg}".}

\item{fold_fixed}{Vector of length \eqn{n}. Each element corresponds to the
fold of the corresponding fold. If NULL then that argument is not considerd.
Default to NULL.}

\item{maxIter_imput}{Positive integer. Maximal number of iterations in the
Tribe Stage of the Koh-Lanta algorithm. If equals to \eqn{0}, mean imputation is
 considered. Default is \eqn{5}.}

\item{errMin_imput}{Positive real. Minimal error in the Tribe Stage of the
Koh-Lanta algorithm. Default is \eqn{1e-9}.}

\item{NCORES}{Integer. The number of cores. Default is \eqn{1}.}
}
\value{
A result of the perf function
}
\description{
That function must be applied to the given dataset and
the cross-validation process is made on the given set
of parameters.
}
\examples{
library(doParallel)
# Classification example :
data("penicilliumYES")
X <- penicilliumYES$X
X <- scale(X[,which(apply(X,2,sd)>0)])
Y <- as.factor(unlist(lapply(c("Melanoconidiu","Polonicum","Venetum"),
function(tt){rep(tt,12)})))
#res_cv_class <- perf_mddsPLS(X,Y,lambda_min=0.85,n_lambda=2,R = 2,
#mode = "clas",NCORES = 1,fold_fixed = rep(1:12,3))

# Regression example :
data("liver.toxicity")
X <- scale(liver.toxicity$gene)
Y <- scale(liver.toxicity$clinic)
#res_cv_reg <- perf_mddsPLS(Xs = X,Y = Y,lambda_min=0.8,n_lambda=2,R = 1,
# mode = "reg")
}
