% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dda_vardist.r
\name{dda.vardist}
\alias{dda.vardist}
\alias{print.dda.vardist}
\title{Direction Dependence Analysis: Variable Distributions}
\usage{
dda.vardist(
  formula,
  pred = NULL,
  data = list(),
  B = 200,
  boot.type = "perc",
  conf.level = 0.95
)

\method{print}{dda.vardist}(x, ...)
}
\arguments{
\item{formula}{Symbolic formula of the model to be tested or a \code{lm}object.}

\item{pred}{Variable name of the predictor which serves as the outcome in the alternative model.}

\item{data}{An optional data frame containing the variables in the
model (by default variables are taken from the environment
which \code{dda.vardist} is called from).}

\item{B}{Number of bootstrap samples.}

\item{boot.type}{A character indicating the type of bootstrap confidence intervals. Must be one of the two specifications c("perc", "bca"). boot.type = "perc" is the default.}

\item{conf.level}{Confidence level for bootstrap confidence intervals.}

\item{x}{An object of class \code{dda.vardist} when using \code{print}.}

\item{...}{Additional arguments to be passed to the function.}
}
\value{
An object of class \code{dda.vardist} containing the results of DDA tests 
         of asymmetry patterns of variable distributions.

An object of class \code{dda.vardist}.
}
\description{
\code{dda.vardist} evaluates patterns of asymmetry of variable
             distributions for causally competing models
             (\code{y ~ x} vs. \code{x ~ y}).

\code{print} returns DDA test statistics associated with \code{dda.vardist} objects.
}
\examples{
set.seed(123)
n <- 500

x <- rchisq(n, df = 4) - 4
e <- rchisq(n, df = 3) - 3
y <- 0.5 * x + e
d <- data.frame(x, y)

result <- dda.vardist(y ~ x, pred = "x", data = d, B = 50)

print(result)
}
\references{
Wiedermann, W., & von Eye, A. (2025). \emph{Direction Dependence Analysis: Foundations and Statistical Methods}. Cambridge, UK: Cambridge University Press.
}
\seealso{
\code{\link{cdda.vardist}} for a conditional version.
}
