% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_all_nodes_parser.R
\name{drug_element}
\alias{drug_element}
\title{extracts the given drug elements and return data as list of tibbles.}
\usage{
drug_element(
  elements_options = c("all"),
  save_table = FALSE,
  save_csv = FALSE,
  csv_path = ".",
  override_csv = FALSE,
  database_connection = NULL
)
}
\arguments{
\item{elements_options}{list,  options of elements to be parsed. default is
"all"}

\item{save_table}{boolean, save table in database if true.}

\item{save_csv}{boolean, save csv version of parsed tibble if true}

\item{csv_path}{location to save csv files into it, default is current
location, save_csv must be true}

\item{override_csv}{override existing csv, if any, in case it is true in the
new parse operation}

\item{database_connection}{DBI connection object that holds a connection to
user defined database. If \code{save_table} is enabled without providing
value for this function an error will be thrown.
@return list of selected drug elements tibbles}
}
\description{
\code{drug_element} returns list of tibbles of drugs selected
elements.
}
\details{
this functions extracts selected element of drug nodes in \strong{DrugBank}
xml database with the option to save it in a predefined database via
passed database connection. it takes two optional arguments to
save the returned tibble in the database \code{save_table} and
 \code{database_connection}.
it must be called after \code{\link{read_drugbank_xml_db}} function like
any other parser function.
if \code{\link{read_drugbank_xml_db}} is called before for any reason, so
no need to call it again before calling this function.

drug_element_options can be called to know the valid options for
this method
}
\examples{
\dontrun{
# return only the parsed tibble
drug_element()

# will throw an error, as database_connection is NULL
drug_element(save_table = TRUE)

# save parsed tibble as csv if it does not exist in current location and
# return parsed tibble.
# if the csv exist before read it and return its data.
drug_element(save_csv = TRUE)


sqlite_con <- DBI::dbConnect(RSQLite::SQLite())
drug_element(save_table = TRUE, database_connection = sqlite_con)

# save in database, save parsed tibble as csv if it does not
# exist in current location and return parsed tibble.
# if the csv exist before read it and return its data.
drug_element(save_table = TRUE, save_csv = TRUE,
 database_connection = sqlite_con)

# save parsed tibble as csv if it does not exist in given location and
# return parsed tibble.
# if the csv exist before read it and return its data.
drug_element(save_csv = TRUE, csv_path = TRUE)

# save parsed tibble as csv if it does not exist in current
# location and return parsed tibble.
# if the csv exist override it and return it.
drug_element(save_csv = TRUE, csv_path = TRUE, override = TRUE)
drug_element(c("drug_ahfs_codes", "drug_carriers"), save_table = TRUE)
drug_element(save_table = FALSE)
drug_element(c("drug_ahfs_codes", "drug_carriers"))
}
}
\seealso{
Other common: 
\code{\link{drug_element_options}()},
\code{\link{run_all_parsers}()}
}
\concept{common}
