% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbcsp.R
\docType{methods}
\name{train}
\alias{train}
\alias{train,dbcsp-method}
\title{Training process of a dbcsp object, using LDA classifier.}
\usage{
train(
  object,
  selected_q = object@q,
  fold = object@fold,
  seed = object@seed,
  verbose = TRUE
)

\S4method{train}{dbcsp}(
  object,
  selected_q = object@q,
  fold = object@fold,
  seed = object@seed,
  verbose = TRUE
)
}
\arguments{
\item{object}{object of class \code{\link[=dbcsp-class]{dbcsp}}.}

\item{selected_q}{integer value indicating the number of vectors to use when training the model, by default \code{selected_q=object@q}.}

\item{fold}{integer value, by default \code{fold=object@fold}. It controls the number of partitions. If \code{fold==1} a train/test
split is performed, with p=0.2 for test indices.}

\item{seed}{numeric value, by default \code{fold=object@seed}. Set a seed in case the results want to be replicable.}

\item{verbose}{logical}
}
\value{
The \code{\link[=dbcsp-class]{dbcsp}} object with the training results saved as list in \code{object@out}:
\itemize{
\item \code{vectors} The projection vectors obtained after applying CSP.
\item \code{eig} The eigenvalues obtained after applying CSP.
\item \code{proy} The variance values of the proyected signals obtained after applying CSP.
\item \code{acc} The mean accuracy value obtained for training data applying cross validation.
\item \code{used_folds} List of the folds used in the cross validation.
\item \code{folds_acc} Accuracy values for each of the folds of the cross validation.
\item \code{model} The trained LDA classifier.
\item \code{selected_q} The number of vectors used when training.
}
}
\description{
This function applies DB-CSP to the instances and perform the training of a Linear Discriminant
Analysis (LDA) classifier using the object data.
}
\examples{
# Read data from 2 classes
x <- AR.data$come[1:20]
y <- AR.data$five[1:20]
mydbcsp <- new("dbcsp", X1 = x, X2 = y)
mydbcsp <- train(mydbcsp,fold=3)
print(mydbcsp@out$acc)
}
\seealso{
\code{\link[=dbcsp-class]{dbcsp}}, \code{\link[=print.dbcsp]{print}}, \code{\link[=summary.dbcsp]{summary}}, \code{\link{selectQ}}, \code{\link[=predict.dbcsp]{predict}}, \code{\link[=plot.dbcsp]{plot}}, \code{\link[=boxplot.dbcsp]{boxplot}}
}
