% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimension_check.R
\name{dimension_check}
\alias{dimension_check}
\title{Dimension Check}
\usage{
dimension_check(DD.dict, DS.data, verbose = TRUE)
}
\arguments{
\item{DD.dict}{Data dictionary.}

\item{DS.data}{Data set.}

\item{verbose}{When TRUE, the function prints the Message out, as well as the number of variables in the data set and data dictionary.}
}
\value{
Tibble, returned invisibly, containing: (1) Time (Time stamp); (2) Name (Name of the function); (3) Status (Passed/Failed); (4) Message (A copy of the message the function printed out); (5) Information (number of variables in the data and dictionary and names of mismatched variables if applicable).
}
\description{
This function checks that the number of variables match between the data set and the data dictionary.
}
\examples{
# Example 1: Fail check
data(ExampleG)
dimension_check(DD.dict.G, DS.data.G)
print(dimension_check(DD.dict=DD.dict.G, DS.data=DS.data.G,verbose=FALSE))

# Example 2: Pass check
data(ExampleA)
dimension_check(DD.dict.A, DS.data.A)
print(dimension_check(DD.dict.A, DS.data.A,verbose=FALSE))
}
