% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_title.R
\name{dataset_title}
\alias{dataset_title}
\alias{dataset_title<-}
\title{Get/set the title of a dataset}
\usage{
dataset_title(x)

dataset_title(x, overwrite = FALSE) <- value
}
\arguments{
\item{x}{A dataset object created with \code{\link[=dataset_df]{dataset_df()}} or \code{\link[=as_dataset_df]{as_dataset_df()}}.}

\item{overwrite}{If the attributes should be overwritten. In case it is set
to \code{FALSE},it gives a warning with the current \code{title}
property instead of overwriting it. Defaults to \code{FALSE}.}

\item{value}{The name(s) or title(s) by which a resource is known. See:
\href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/elements11/title/}{dct:title}.}
}
\value{
A string with the dataset's title; \code{set_dataset_title} returns
a dataset object with the changed (main) title.
}
\description{
Get or reset the dataset's main title.
}
\details{
In the DataCite definition, several titles can be used; it is not
yet implemented.
}
\examples{
dataset_title(iris_dataset)
dataset_title(iris_dataset, overwrite = TRUE) <-"The Famous Iris Dataset"
dataset_title(iris_dataset)
}
\seealso{
Other Bibliographic reference functions: 
\code{\link{creator}()}
}
\concept{Bibliographic reference functions}
