% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StarredModels.R
\name{ListStarredModels}
\alias{ListStarredModels}
\title{List all the starred models in a project.}
\usage{
ListStarredModels(project, orderBy = NULL)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{orderBy}{character. Optional. A vector of keys to order the list by. You can
order by \code{metric} or \code{samplePct}. If the sort attribute is preceded by a
hyphen, models will be sorted in descending order, otherwise in ascending order.
Multiple sort attributes can be included as a comma-delimited string or in a vector.}
}
\value{
An S3 object of class listOfModels, which may be characterized
  using R's generic summary function or converted to a dataframe with
  the as.data.frame method.
}
\description{
Star models and add them to this list using \code{StarModel} or \code{ToggleStarForModel}.
Unstar models and remove them from this list using \code{UnstarModel} or
\code{ToggleStarForModel}
}
\examples{
\dontrun{
   projectId <- "59a5af20c80891534e3c2bde"
   ListStarredModels(projectId)
}
}
