% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetPredictions.R
\name{Predict}
\alias{Predict}
\title{Retrieve model predictions}
\usage{
Predict(
  model,
  predictionDataset,
  classPrefix = "class_",
  maxWait = 600,
  forecastPoint = NULL,
  predictionsStartDate = NULL,
  predictionsEndDate = NULL,
  type = "response",
  includePredictionIntervals = FALSE,
  predictionIntervalsSize = NULL
)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModel, or each element of the list returned by
the function ListModels.}

\item{predictionDataset}{object. Either a dataframe of data to predict on or a DataRobot
prediction dataset object of class \code{dataRobotPredictionDataset}.}

\item{classPrefix}{character. For multiclass projects returning prediction probabilities,
this prefix is prepended to each class in the header of the dataframe. Defaults to
"class_".}

\item{maxWait}{integer. The maximum time (in seconds) to wait for the prediction job
to complete.}

\item{forecastPoint}{character. Optional. The point relative to which predictions will be
generated, based on the forecast window of the project. Only specified in time series
projects.}

\item{predictionsStartDate}{datetime. Optional. Only specified in time series projects.
The start date for bulk predictions. This parameter should be provided in conjunction
\code{predictionsEndDate}. Can't be provided with \code{forecastPoint} parameter.}

\item{predictionsEndDate}{datetime. Optional. Only specified in time series projects.
The end date for bulk predictions. This parameter should be provided in conjunction
\code{predictionsStartDate}. Can't be provided with \code{forecastPoint} parameter.}

\item{type}{character. String specifying the type of response for
binary classifiers; see Details.}

\item{includePredictionIntervals}{logical. Optional. Should prediction intervals bounds should be
part of predictions? Only available for time series projects. See "Details" for more
info.}

\item{predictionIntervalsSize}{numeric. Optional. Size of the prediction intervals, in percent.
Only available for time series projects. See "Details" for more info.}
}
\value{
Vector of predictions, depending on the modeling task
("Binary", "Multiclass", or "Regression") and the value of the type parameter;
see Details.
}
\description{
This function can be used to predict with a particular model.
}
\details{
The contents of the return vector depends on the modeling
task - binary classification, multiclass classification, or regression;
whether or not the underlying data is time series, multiseries, cross-series, or not
time series; and the value of the /code{type} parameter. For non-time-series regression tasks,
the type parameter is ignored and a vector of numerical predictions of the response
variable is returned.

This function will error if the requested job has errored, or
if it does not complete within \code{maxWait} seconds.

See \code{RequestPredictions} and \code{GetPredictions} for more details.
}
\examples{
\dontrun{
   trainIndex <- sample(nrow(iris) * 0.7)
   trainIris <- iris[trainIndex, ]
   testIris <- iris[-trainIndex, ]
   project <- StartProject(trainIris, "iris", target = "Petal_Width", wait = TRUE)
   model <- GetRecommendedModel(project)
   predictions <- Predict(model, testIris)

   # Or, if prediction intervals are desired (datetime only)
   model <- GetRecommendedModel(datetimeProject)
   predictions <- Predict(datetimeModel,
                          dataset,
                          includePredictionIntervals = TRUE,
                          predictionIntervalsSize = 100,
                          type = "raw")
}
}
