% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{RequestNewModel}
\alias{RequestNewModel}
\title{Adds a new model of type specified by blueprint to a DataRobot project}
\usage{
RequestNewModel(project, blueprint, featurelist = NULL, samplePct = NULL,
  trainingRowCount = NULL, scoringType = NULL,
  monotonicIncreasingFeaturelistId = NULL,
  monotonicDecreasingFeaturelistId = NULL)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{blueprint}{list. A list with at least the following two elements:
blueprintId and projectId.  Note that the individual elements of the
list returned by ListBlueprints are admissible values for this parameter.}

\item{featurelist}{list. A list that contains the element featurelistId that
specifies the featurelist to be used in building the model; if not
specified (i.e., for the default value NULL), the project default
(Informative Features) is used.}

\item{samplePct}{numeric. The percentage of the training
dataset to be used in building the new model; if not specified
(i.e., for the default value NULL), the maxTrainPct value for the
project is used. Value should be between 0 and 100.}

\item{trainingRowCount}{integer. The number of rows to use to train
the requested model.}

\item{scoringType}{character. String specifying the scoring type;
default is validation set scoring, but cross-validation averaging
is also possible.}

\item{monotonicIncreasingFeaturelistId}{character. Optional. The id of the featurelist
that defines the set of features with a monotonically increasing relationship to the
target. If \code{NULL} (default), the default for the project will be used (if any).
Note that currently there is no way to create a model without monotonic constraints
if there was a project-level default set.}

\item{monotonicDecreasingFeaturelistId}{character. Optional. The id of the featurelist
that defines the set of features with a monotonically decreasing relationship to the
target. If \code{NULL} (default), the default for the project will be used (if any).
Note that currently there is no way to create a model without monotonic constraints
if there was a project-level default set.}
}
\value{
An integer value that can be used as the modelJobId parameter
  in subsequent calls to the GetModelFromJobId function.
}
\description{
This function requests the creation of a new model in the DataRobot
modeling project defined by the project parameter.  The function also
allows the user to specify alternatives to the project default for
featurelist, samplePct, and scoringType.  This function returns an
integer modelJobId value, which can be used by the GetModelFromJobId
function to return the full model object.
}
\details{
Motivation for this function is the fact that some models - e.g., very
complex machine learning models fit to large datasets - may take a long
time to complete.  Splitting the model creation request from model
retrieval in these cases allows the user to perform other interactive R
session tasks between the time the model creation/update request is made
and the time the final model is available.

Either `sample_pct` or `training_row_count` can be used to specify the amount of data to
use, but not both. If neither are specified, a default of the maximum amount of data that
can safely be used to train any blueprint without going into the validation data will be
selected.
In smart-sampled projects, `samplePct` and `trainingRowCount` are assumed to be in terms of rows
of the minority class.

Note : For datetime partitioned projects, use \code{RequestNewDatetimeModel} instead
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  blueprints <- ListBlueprints(projectId)
  blueprint <- blueprints[[1]]
  RequestNewModel(projectId, blueprint)
}
}
