% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_looks_like_missing.R
\name{util_looks_like_missing}
\alias{util_looks_like_missing}
\title{Check for repetitive values using the digits 8 or 9 only}
\usage{
util_looks_like_missing(x, n_rules = 1)
}
\arguments{
\item{x}{\code{\link{numeric}} vector to test}

\item{n_rules}{\code{\link{numeric}} Only outlying values can be missing
codes; at least \code{n_rules} rules in
\code{\link{acc_univariate_outlier}} match}
}
\value{
\code{\link{logical}} indicates for each value in \code{x}, if it looks like a
missing code
}
\description{
Values not being finite (see \code{\link{is.finite}}) are also reported as missing
codes. Also, all missing codes must be composed out of the digits 8 and
9 and they must be the largest values of a variable.
}
\seealso{
\code{\link{acc_univariate_outlier}}

Other metadata_management: 
\code{\link{util_dist_selection}()},
\code{\link{util_find_free_missing_code}()},
\code{\link{util_find_var_by_meta}()},
\code{\link{util_get_var_att_names_of_level}()},
\code{\link{util_get_vars_in_segment}()},
\code{\link{util_no_value_labels}()},
\code{\link{util_validate_known_meta}()},
\code{\link{util_validate_missing_lists}()}
}
\concept{metadata_management}
\concept{missing}
\keyword{internal}
