% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Package.R
\name{Package.load}
\alias{Package.load}
\title{Instantiate \code{Data Package} class}
\usage{
Package.load(descriptor = list(), basePath = NA, strict = FALSE)
}
\arguments{
\item{descriptor}{Data package descriptor as local path, url or object.}

\item{basePath}{Base path for all relative paths}

\item{strict}{Strict flag to alter validation behavior. 
Setting it to \code{TRUE} leads to throwing errors on any operation with invalid descriptor.}
}
\description{
Constructor to instantiate \code{Package} class.
}
\examples{

# Load local descriptor
descriptor <- system.file('extdata/dp1/datapackage.json', 
                         package = "datapackage.r")
dataPackage <- Package.load(descriptor)
dataPackage$descriptor


# Retrieve Package Descriptor
descriptor2 <- '{"resources": [{"name": "name", "data": ["data"]}]}'
dataPackage2 <- Package.load(descriptor2)
dataPackage2$descriptor


# Expand Resource Descriptor
descriptor3 <- helpers.from.json.to.list('{"resources": 
                                         [{"name": "name",
                                          "data": ["data"]}]}')
dataPackage3 <- Package.load(descriptor3)
dataPackage3$descriptor


# Add, Get and Remove Package Resources
descriptor4 <- helpers.from.json.to.list(
       system.file('extdata/dp1/datapackage.json', 
                     package = "datapackage.r"))
dataPackage4 <- Package.load(descriptor4)
resource4 <- dataPackage4$addResource(
        helpers.from.json.to.list('{"name": "name", "data": ["test"]}'))
dataPackage4$resources[[2]]$source


# Get resource
dataPackage4$getResource('name')


# Remove resource
dataPackage4$removeResource('name')
dataPackage4$getResource('name')


# Modify and Commit Data Package
descriptor5 <- helpers.from.json.to.list(
        '{"resources": [{"name": "name", "data": ["data"]}]}')
dataPackage5 <- Package.load(descriptor5)
dataPackage5$descriptor$resources[[1]]$name <- 'modified'


## Name did not modified.
dataPackage5$resources[[1]]$name


## Should commit the changes
dataPackage5$commit() # TRUE - successful commit 
dataPackage5$resources[[1]]$name

}
\seealso{
\code{\link{Package}}, 
\href{https://frictionlessdata.io/specs/data-package/#specification}{Data Package Specifications}
}
