% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResourceMap.R
\docType{methods}
\name{getTriples}
\alias{getTriples}
\alias{getTriples,ResourceMap-method}
\title{Get the RDF relationships stored in the ResourceMap.}
\usage{
getTriples(x, ...)

\S4method{getTriples}{ResourceMap}(x, filter = TRUE,
  identifiers = list(), ...)
}
\arguments{
\item{x}{ResourceMap}

\item{...}{Additional parameters (not yet implemented).}

\item{filter}{A \code{logical} value. If TRUE, then DataONE packaging relationships are omitted.}

\item{identifiers}{A list of \code{character} values of the identifiers of DataPackage members.}
}
\value{
x A data.frame containing the relationships from the ResourceMap
}
\description{
The \code{getTriples} method extracts the RDF relationships from a ResourceMap.
}
\details{
The \code{filter} argument causes DataONE packaging relationships to be removed. 
A description of these can be viewed at https://purl.dataone.org/architecture/design/DataPackage.html. 
The \code{identifiers} parameter can contain a list of DataPackage members for which the 
identifiers will be 'demoted', that is any relationship that has these identifiers as a 
URL as the subject or object will be changed to the 'bare' identifier. The intent of these two parameter is to
transform the DataPackage to a 'local' state, so that it can be more easily updated locally.
}
