/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphStatisticsHandler;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.AllCapabilities;
import com.hp.hpl.jena.graph.impl.GraphMatcher;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.graph.impl.SimpleTransactionHandler;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.shared.AddDeniedException;
import com.hp.hpl.jena.shared.ClosedException;
import com.hp.hpl.jena.shared.DeleteDeniedException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public abstract class GraphBase
implements GraphWithPerform {
    protected final ReificationStyle style;
    protected boolean closed = false;
    protected QueryHandler queryHandler;
    protected GraphStatisticsHandler statisticsHandler;
    protected GraphEventManager gem;
    protected BulkUpdateHandler bulkHandler;
    protected Capabilities capabilities = null;
    protected PrefixMapping pm = new PrefixMappingImpl();
    protected Reifier reifier = null;

    public GraphBase() {
        this(ReificationStyle.Minimal);
    }

    public GraphBase(ReificationStyle style) {
        this.style = style;
    }

    protected void checkOpen() {
        if (this.closed) {
            throw new ClosedException("already closed", this);
        }
    }

    public void close() {
        this.closed = true;
        if (this.reifier != null) {
            this.reifier.close();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean dependsOn(Graph other) {
        return this == other;
    }

    public QueryHandler queryHandler() {
        if (this.queryHandler == null) {
            this.queryHandler = new SimpleQueryHandler(this);
        }
        return this.queryHandler;
    }

    public GraphStatisticsHandler getStatisticsHandler() {
        if (this.statisticsHandler == null) {
            this.statisticsHandler = this.createStatisticsHandler();
        }
        return this.statisticsHandler;
    }

    protected GraphStatisticsHandler createStatisticsHandler() {
        return null;
    }

    public GraphEventManager getEventManager() {
        if (this.gem == null) {
            this.gem = new SimpleEventManager(this);
        }
        return this.gem;
    }

    public void notifyAdd(Triple t) {
        this.getEventManager().notifyAddTriple(this, t);
    }

    public void notifyDelete(Triple t) {
        this.getEventManager().notifyDeleteTriple(this, t);
    }

    public TransactionHandler getTransactionHandler() {
        return new SimpleTransactionHandler();
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new SimpleBulkUpdateHandler(this);
        }
        return this.bulkHandler;
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new AllCapabilities();
        }
        return this.capabilities;
    }

    public PrefixMapping getPrefixMapping() {
        return this.pm;
    }

    public void add(Triple t) {
        this.checkOpen();
        this.performAdd(t);
        this.notifyAdd(t);
    }

    public void performAdd(Triple t) {
        throw new AddDeniedException("GraphBase::performAdd");
    }

    public final void delete(Triple t) {
        this.checkOpen();
        this.performDelete(t);
        this.notifyDelete(t);
    }

    public void performDelete(Triple t) {
        throw new DeleteDeniedException("GraphBase::delete");
    }

    public final ExtendedIterator find(TripleMatch m) {
        this.checkOpen();
        return this.reifierTriples(m).andThen(this.graphBaseFind(m));
    }

    protected abstract ExtendedIterator graphBaseFind(TripleMatch var1);

    public ExtendedIterator forTestingOnly_graphBaseFind(TripleMatch tm) {
        return this.graphBaseFind(tm);
    }

    public final ExtendedIterator find(Node s, Node p, Node o) {
        this.checkOpen();
        return this.graphBaseFind(s, p, o);
    }

    protected ExtendedIterator graphBaseFind(Node s, Node p, Node o) {
        return this.find(Triple.createMatch(s, p, o));
    }

    public final boolean contains(Triple t) {
        this.checkOpen();
        return this.reifierContains(t) || this.graphBaseContains(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean reifierContains(Triple t) {
        ExtendedIterator it = this.getReifier().findExposed(t);
        try {
            boolean bl = it.hasNext();
            return bl;
        }
        finally {
            it.close();
        }
    }

    protected boolean graphBaseContains(Triple t) {
        return this.containsByFind(t);
    }

    public final boolean contains(Node s, Node p, Node o) {
        this.checkOpen();
        return this.contains(Triple.create(s, p, o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean containsByFind(Triple t) {
        ExtendedIterator it = this.find(t);
        try {
            boolean bl = it.hasNext();
            return bl;
        }
        finally {
            it.close();
        }
    }

    protected ExtendedIterator reifierTriples(TripleMatch m) {
        return this.getReifier().findExposed(m);
    }

    public Reifier getReifier() {
        if (this.reifier == null) {
            this.reifier = this.constructReifier();
        }
        return this.reifier;
    }

    protected Reifier constructReifier() {
        return new SimpleReifier(this, this.style);
    }

    public final int size() {
        this.checkOpen();
        int baseSize = this.graphBaseSize();
        int reifierSize = this.reifierSize();
        return baseSize + reifierSize;
    }

    protected int reifierSize() {
        return this.getReifier().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int graphBaseSize() {
        ExtendedIterator it = GraphUtil.findAll(this);
        try {
            int tripleCount = 0;
            while (it.hasNext()) {
                it.next();
                ++tripleCount;
            }
            int n = tripleCount;
            return n;
        }
        finally {
            it.close();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isIsomorphicWith(Graph g) {
        this.checkOpen();
        return g != null && GraphMatcher.equals(this, g);
    }

    public String toString() {
        return GraphBase.toString(this.closed ? "closed " : "", this);
    }

    public static String toString(String prefix, Graph that) {
        PrefixMapping pm = that.getPrefixMapping();
        StringBuffer b = new StringBuffer(prefix + " {");
        String gap = "";
        ExtendedIterator it = GraphUtil.findAll(that);
        while (it.hasNext()) {
            b.append(gap);
            gap = "; ";
            b.append(((Triple)it.next()).toString(pm));
        }
        b.append("}");
        return b.toString();
    }
}

