/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites.optimizer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.ProbabilityFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityIndexModel;
import com.hp.hpl.jena.sparql.suites.optimizer.Util;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestProbabilityIndexModel
extends TestCase {
    private Triple triple1;
    private Triple triple2;
    private double probability;
    private double selectivity;
    private static double minProbability;
    private static double minJoinedProbability;
    private static long dataGraphSize;
    private static long indexedSize;
    private static long squaredDataGraphSize;
    private static long squaredIndexedSize;
    private static ProbabilityIndexModel statistics;
    private static Model graphM;
    private static Model testsM;
    private static Model indexM;
    private static Model dataM;
    private static final String testDataFileName = "testing/Optimizer/Test-data.n3";
    private static final String testCaseFileName = "testing/Optimizer/TestProbabilityIndexModel-manifest.n3";

    public TestProbabilityIndexModel(String title, Triple triple1, Triple triple2, double probability, double selectivity) {
        super(title);
        this.triple1 = triple1;
        this.triple2 = triple2;
        this.probability = probability;
        this.selectivity = selectivity;
    }

    protected void runTest() {
        double p = statistics.getProbability(this.triple1, this.triple2);
        double s = statistics.getSelectivity(this.triple1, this.triple2);
        TestProbabilityIndexModel.assertTrue((statistics.getMinProbability() == minProbability ? 1 : 0) != 0);
        TestProbabilityIndexModel.assertTrue((statistics.getMinJoinedProbability() == minJoinedProbability ? 1 : 0) != 0);
        TestProbabilityIndexModel.assertTrue((statistics.getDataGraphSize() == dataGraphSize ? 1 : 0) != 0);
        TestProbabilityIndexModel.assertTrue((statistics.getIndexedSize() == indexedSize ? 1 : 0) != 0);
        TestProbabilityIndexModel.assertTrue((statistics.getSquaredDataGraphSize() == squaredDataGraphSize ? 1 : 0) != 0);
        TestProbabilityIndexModel.assertTrue((statistics.getSquaredIndexedSize() == squaredIndexedSize ? 1 : 0) != 0);
        TestProbabilityIndexModel.assertTrue((String)("Actual: " + p + " Target: " + this.probability), (p == this.probability ? 1 : 0) != 0);
        TestProbabilityIndexModel.assertTrue((String)("Actual: " + s + " Target: " + this.selectivity), (s == this.selectivity ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void oneTimeSetUp() {
        QueryExecution qe = QueryExecutionFactory.create(TestProbabilityIndexModel.queryGenericTestCase(), testsM);
        try {
            ResultSet rs = qe.execSelect();
            QuerySolution solution = rs.nextSolution();
            minProbability = solution.getLiteral("minProbability").getDouble();
            minJoinedProbability = solution.getLiteral("minJoinedProbability").getDouble();
            dataGraphSize = solution.getLiteral("dataGraphSize").getLong();
            indexedSize = solution.getLiteral("indexedSize").getLong();
            squaredDataGraphSize = solution.getLiteral("squaredDataGraphSize").getLong();
            squaredIndexedSize = solution.getLiteral("squaredIndexedSize").getLong();
        }
        finally {
            qe.close();
        }
        dataM = Util.readModel(testDataFileName);
        indexM = ProbabilityFactory.createIndex(dataM);
        statistics = (ProbabilityIndexModel)ProbabilityFactory.loadIndexModel(dataM, indexM, null);
    }

    public static void oneTimeTearDown() {
        graphM.close();
        testsM.close();
        dataM.close();
        indexM.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Test suite() {
        TestSuite ts = new TestSuite("TestProbabilityIndexModel");
        graphM = Util.readModel(testDataFileName);
        testsM = Util.readModel(testCaseFileName);
        QueryExecution qe = QueryExecutionFactory.create(TestProbabilityIndexModel.queryTestCases(), testsM);
        try {
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                Triple triple1 = null;
                Triple triple2 = null;
                QuerySolution solution = rs.nextSolution();
                String title = solution.getLiteral("title").getLexicalForm();
                double probability = solution.getLiteral("probability").getDouble();
                double selectivity = solution.getLiteral("selectivity").getDouble();
                triple1 = TestProbabilityIndexModel.getTriple(solution.getResource("triple1"));
                if (solution.getResource("triple2") != null) {
                    triple2 = TestProbabilityIndexModel.getTriple(solution.getResource("triple2"));
                }
                ts.addTest((Test)new TestProbabilityIndexModel(title, triple1, triple2, probability, selectivity));
            }
        }
        finally {
            qe.close();
        }
        TestSetup wrapper = new TestSetup((Test)ts){

            protected void setUp() {
                TestProbabilityIndexModel.oneTimeSetUp();
            }

            protected void tearDown() {
                TestProbabilityIndexModel.oneTimeTearDown();
            }
        };
        return wrapper;
    }

    private static Triple getTriple(Resource resource) {
        Node s = null;
        Node p = null;
        Node o = null;
        StmtIterator stmtIter = testsM.listStatements(resource, (Property)null, (RDFNode)null);
        while (stmtIter.hasNext()) {
            Statement stmt = stmtIter.nextStatement();
            Property predicate = stmt.getPredicate();
            String predicateURI = predicate.getURI();
            if (predicateURI.equals("http://www.w3.org/2006/03/test-description#subject")) {
                s = Util.createNode(stmt.getObject().asNode().getLiteralLexicalForm());
                continue;
            }
            if (predicateURI.equals("http://www.w3.org/2006/03/test-description#predicate")) {
                p = Util.createNode(stmt.getObject().asNode().getLiteralLexicalForm());
                continue;
            }
            if (!predicateURI.equals("http://www.w3.org/2006/03/test-description#object")) continue;
            o = Util.createNode(stmt.getObject().asNode().getLiteralLexicalForm());
        }
        stmtIter.close();
        return new Triple(s, p, o);
    }

    private static String queryTestCases() {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX dc: <http://purl.org/dc/elements/1.1/>PREFIX : <http://www.w3.org/2006/03/test-description#>SELECT ?title ?triple1 ?triple2 ?probability ?selectivity WHERE {?tc rdf:type :TestCase .?tc dc:title ?title .?tc :triple1 ?triple1 .OPTIONAL { ?tc :triple2 ?triple2 } ?tc :probability ?probability .?tc :selectivity ?selectivity .}ORDER BY ASC(?title)";
    }

    private static String queryGenericTestCase() {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX dc: <http://purl.org/dc/elements/1.1/>PREFIX : <http://www.w3.org/2006/03/test-description#>SELECT ?minProbability ?minJoinedProbability ?dataGraphSize ?indexedSize ?squaredDataGraphSize ?squaredIndexedSize WHERE {?tc rdf:type :TestCase .?tc :minProbability ?minProbability .?tc :minJoinedProbability ?minJoinedProbability .?tc :dataGraphSize ?dataGraphSize .?tc :indexedSize ?indexedSize .?tc :squaredDataGraphSize ?squaredDataGraphSize .?tc :squaredIndexedSize ?squaredIndexedSize .}";
    }
}

