/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.client.ClientProtocolException;
import org.dataone.client.D1Node;
import org.dataone.client.D1RestClient;
import org.dataone.configuration.Settings;
import org.dataone.mimemultipart.SimpleMultipartEntity;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.SynchronizationFailed;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.mn.tier1.v1.MNCore;
import org.dataone.service.mn.tier1.v1.MNRead;
import org.dataone.service.mn.tier2.v1.MNAuthorization;
import org.dataone.service.mn.tier3.v1.MNStorage;
import org.dataone.service.mn.tier4.v1.MNReplication;
import org.dataone.service.mn.v1.MNQuery;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.DescribeResponse;
import org.dataone.service.types.v1.Event;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Node;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.service.types.v1_1.QueryEngineDescription;
import org.dataone.service.types.v1_1.QueryEngineList;
import org.dataone.service.util.D1Url;
import org.dataone.service.util.DateTimeMarshaller;
import org.jibx.runtime.JiBXException;

public class MNode
extends D1Node
implements MNCore,
MNRead,
MNAuthorization,
MNStorage,
MNReplication,
MNQuery {
    protected static Log log = LogFactory.getLog(MNode.class);

    public MNode(String nodeBaseServiceUrl) {
        super(nodeBaseServiceUrl);
    }

    public MNode(String nodeBaseServiceUrl, Session session) {
        super(nodeBaseServiceUrl, session);
    }

    @Override
    public String getNodeBaseServiceUrl() {
        D1Url url = new D1Url(super.getNodeBaseServiceUrl());
        url.addNextPathElement("v1");
        log.debug((Object)("Node base service URL is: " + url.getUrl()));
        return url.getUrl();
    }

    @Override
    public Date ping() throws NotImplemented, ServiceFailure, InsufficientResources {
        return super.ping();
    }

    @Override
    public org.dataone.service.types.v1.Log getLogRecords() throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        org.dataone.service.types.v1.Log theLog = null;
        try {
            theLog = super.getLogRecords();
        }
        catch (InsufficientResources e) {
            throw MNode.recastDataONEExceptionToServiceFailure((BaseException)((Object)e));
        }
        return theLog;
    }

    @Override
    public org.dataone.service.types.v1.Log getLogRecords(Session session) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        org.dataone.service.types.v1.Log theLog = null;
        try {
            theLog = super.getLogRecords(session);
        }
        catch (InsufficientResources e) {
            throw MNode.recastDataONEExceptionToServiceFailure((BaseException)((Object)e));
        }
        return theLog;
    }

    @Override
    public org.dataone.service.types.v1.Log getLogRecords(Date fromDate, Date toDate, Event event, String pidFilter, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        org.dataone.service.types.v1.Log theLog = null;
        try {
            theLog = super.getLogRecords(fromDate, toDate, event, pidFilter, start, count);
        }
        catch (InsufficientResources e) {
            throw MNode.recastDataONEExceptionToServiceFailure((BaseException)((Object)e));
        }
        return theLog;
    }

    @Override
    public org.dataone.service.types.v1.Log getLogRecords(Session session, Date fromDate, Date toDate, Event event, String pidFilter, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        org.dataone.service.types.v1.Log theLog = null;
        try {
            theLog = super.getLogRecords(session, fromDate, toDate, event, pidFilter, start, count);
        }
        catch (InsufficientResources e) {
            throw MNode.recastDataONEExceptionToServiceFailure((BaseException)((Object)e));
        }
        return theLog;
    }

    @Override
    public ObjectList listObjects() throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return super.listObjects();
    }

    @Override
    public ObjectList listObjects(Session session) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return super.listObjects(session);
    }

    @Override
    public ObjectList listObjects(Date fromDate, Date toDate, ObjectFormatIdentifier formatid, Boolean replicaStatus, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return super.listObjects(fromDate, toDate, formatid, replicaStatus, start, count);
    }

    @Override
    public ObjectList listObjects(Session session, Date fromDate, Date toDate, ObjectFormatIdentifier formatid, Boolean replicaStatus, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return super.listObjects(session, fromDate, toDate, formatid, replicaStatus, start, count);
    }

    public Node getCapabilities() throws NotImplemented, ServiceFailure {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "node");
        D1RestClient client = new D1RestClient();
        Node node = null;
        try {
            InputStream is = client.doGetRequest(url.getUrl());
            node = this.deserializeServiceType(Node.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            throw MNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw MNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw MNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw MNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw MNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return node;
    }

    @Override
    public InputStream get(Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, InsufficientResources {
        return super.get(pid);
    }

    @Override
    public InputStream get(Session session, Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, InsufficientResources {
        return super.get(session, pid);
    }

    @Override
    public SystemMetadata getSystemMetadata(Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return super.getSystemMetadata(pid);
    }

    @Override
    public SystemMetadata getSystemMetadata(Session session, Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return super.getSystemMetadata(session, pid);
    }

    @Override
    public DescribeResponse describe(Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return super.describe(pid);
    }

    @Override
    public DescribeResponse describe(Session session, Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return super.describe(session, pid);
    }

    @Override
    public Checksum getChecksum(Identifier pid, String checksumAlgorithm) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return super.getChecksum(pid, checksumAlgorithm);
    }

    @Override
    public Checksum getChecksum(Session session, Identifier pid, String checksumAlgorithm) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return super.getChecksum(session, pid, checksumAlgorithm);
    }

    public boolean synchronizationFailed(SynchronizationFailed message) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return this.synchronizationFailed(this.session, message);
    }

    public boolean synchronizationFailed(Session session, SynchronizationFailed message) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "error");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("message", message.serialize(0));
        }
        catch (IOException e1) {
            throw MNode.recastClientSideExceptionToServiceFailure(e1);
        }
        D1RestClient client = new D1RestClient(session);
        InputStream is = null;
        try {
            is = client.doPostRequest(url.getUrl(), mpe);
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            throw MNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw MNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw MNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw MNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw MNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    @Override
    public boolean isAuthorized(Identifier pid, Permission action) throws ServiceFailure, InvalidRequest, InvalidToken, NotFound, NotAuthorized, NotImplemented {
        return super.isAuthorized(pid, action);
    }

    @Override
    public boolean isAuthorized(Session session, Identifier pid, Permission action) throws ServiceFailure, InvalidRequest, InvalidToken, NotFound, NotAuthorized, NotImplemented {
        return super.isAuthorized(session, pid, action);
    }

    @Override
    public Identifier generateIdentifier(String scheme, String fragment) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        return super.generateIdentifier(scheme, fragment);
    }

    @Override
    public Identifier generateIdentifier(Session session, String scheme, String fragment) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        return super.generateIdentifier(session, scheme, fragment);
    }

    public Identifier create(Identifier pid, InputStream object, SystemMetadata sysmeta) throws IdentifierNotUnique, InsufficientResources, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, UnsupportedType {
        return this.create(this.session, pid, object, sysmeta);
    }

    public Identifier create(Session session, Identifier pid, InputStream object, SystemMetadata sysmeta) throws IdentifierNotUnique, InsufficientResources, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, UnsupportedType {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "object");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addParamPart("pid", pid.getValue());
            mpe.addFilePart("object", object);
            mpe.addFilePart("sysmeta", (Object)sysmeta);
        }
        catch (IOException e) {
            throw MNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (JiBXException e) {
            throw MNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        D1RestClient client = new D1RestClient(session);
        client.setTimeouts(Settings.getConfiguration().getInteger("D1Client.MNode.create.timeout", this.getDefaultSoTimeout()));
        Identifier identifier = null;
        try {
            InputStream is = client.doPostRequest(url.getUrl(), mpe);
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)be;
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidSystemMetadata) {
                throw (InvalidSystemMetadata)be;
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof UnsupportedType) {
                throw (UnsupportedType)be;
            }
            throw MNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw MNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw MNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw MNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw MNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return identifier;
    }

    public Identifier update(Identifier pid, InputStream object, Identifier newPid, SystemMetadata sysmeta) throws IdentifierNotUnique, InsufficientResources, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, UnsupportedType, NotFound {
        return this.update(this.session, pid, object, newPid, sysmeta);
    }

    public Identifier update(Session session, Identifier pid, InputStream object, Identifier newPid, SystemMetadata sysmeta) throws IdentifierNotUnique, InsufficientResources, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, UnsupportedType, NotFound {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "object");
        url.addNextPathElement(pid.getValue());
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        mpe.addParamPart("newPid", newPid.getValue());
        try {
            mpe.addFilePart("object", object);
            mpe.addFilePart("sysmeta", (Object)sysmeta);
        }
        catch (IOException e) {
            throw MNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (JiBXException e) {
            throw MNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        D1RestClient client = new D1RestClient(session);
        client.setTimeouts(Settings.getConfiguration().getInteger("D1Client.MNode.update.timeout", this.getDefaultSoTimeout()));
        Identifier identifier = null;
        try {
            InputStream is = client.doPutRequest(url.getUrl(), mpe);
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)be;
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidSystemMetadata) {
                throw (InvalidSystemMetadata)be;
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof UnsupportedType) {
                throw (UnsupportedType)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw MNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw MNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw MNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw MNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw MNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return identifier;
    }

    @Override
    public Identifier archive(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.archive(pid);
    }

    @Override
    public Identifier archive(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.archive(session, pid);
    }

    @Override
    public Identifier delete(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.delete(pid);
    }

    @Override
    public Identifier delete(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.delete(session, pid);
    }

    public boolean systemMetadataChanged(Identifier pid, long serialVersion, Date dateSystemMetadataLastModified) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        return this.systemMetadataChanged(this.session, pid, serialVersion, dateSystemMetadataLastModified);
    }

    public boolean systemMetadataChanged(Session session, Identifier pid, long serialVersion, Date dateSystemMetadataLastModified) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "dirtySystemMetadata");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        if (pid != null) {
            mpe.addParamPart("pid", pid.getValue());
        }
        mpe.addParamPart("dateSysMetaLastModified", DateTimeMarshaller.serializeDateToUTC((Date)dateSystemMetadataLastModified));
        mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        D1RestClient client = new D1RestClient(session);
        InputStream is = null;
        try {
            is = client.doPostRequest(url.getUrl(), mpe);
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            throw MNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw MNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw MNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw MNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw MNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    public boolean replicate(SystemMetadata sysmeta, NodeReference sourceNode) throws NotImplemented, ServiceFailure, NotAuthorized, InvalidRequest, InvalidToken, InsufficientResources, UnsupportedType {
        return this.replicate(this.session, sysmeta, sourceNode);
    }

    public boolean replicate(Session session, SystemMetadata sysmeta, NodeReference sourceNode) throws NotImplemented, ServiceFailure, NotAuthorized, InvalidRequest, InvalidToken, InsufficientResources, UnsupportedType {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "replicate");
        SimpleMultipartEntity smpe = new SimpleMultipartEntity();
        if (sourceNode != null) {
            smpe.addParamPart("sourceNode", sourceNode.getValue());
        }
        try {
            smpe.addFilePart("sysmeta", (Object)sysmeta);
        }
        catch (IOException e) {
            throw MNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (JiBXException e) {
            throw MNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        D1RestClient client = new D1RestClient(session);
        client.setTimeouts(Settings.getConfiguration().getInteger("D1Client.MNode.replicate.timeout", this.getDefaultSoTimeout()));
        InputStream is = null;
        try {
            is = client.doPostRequest(url.getUrl(), smpe);
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)((Object)be);
            }
            if (be instanceof UnsupportedType) {
                throw (UnsupportedType)be;
            }
            throw MNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw MNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw MNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw MNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw MNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    public InputStream getReplica(Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, InsufficientResources {
        return this.getReplica(this.session, pid);
    }

    public InputStream getReplica(Session session, Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, InsufficientResources {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "replica");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        D1RestClient client = new D1RestClient(session);
        client.setTimeouts(Settings.getConfiguration().getInteger("D1Client.MNode.getReplica.timeout", this.getDefaultSoTimeout()));
        ByteArrayInputStream bais = null;
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)client.doGetRequest(url.getUrl()));
            bais = new ByteArrayInputStream(bytes);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)((Object)be);
            }
            throw MNode.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw MNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw MNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw MNode.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw MNode.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return bais;
    }

    @Override
    public InputStream query(String queryEngine, String query) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        return super.query(queryEngine, query);
    }

    @Override
    public QueryEngineDescription getQueryEngineDescription(String queryEngine) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, NotFound {
        return super.getQueryEngineDescription(queryEngine);
    }

    @Override
    public QueryEngineList listQueryEngines() throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented {
        return super.listQueryEngines();
    }
}

