% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vifx.r
\name{vifx}
\alias{vifx}
\title{Computes the variance inflation factor (VIF) for a
multiple linear regression (MLR) model.}
\usage{
vifx(mod = mod)
}
\arguments{
\item{mod}{an object containing the fitted MLR model by using
the \code{lm()} function.}
}
\value{
This function creates a LaTeX file having
the main fitting statistics of a linear regression model.
}
\description{
Function to compute the variance inflation factor (VIF)
for a multiple linear regression model.
}
\details{
The resulting out is a dataframe having the
VIF for each of the predictor variables.
}
\examples{
##Two fitted models
mod1 <- stats::lm(mpg ~ cyl+disp + hp + wt + drat, data = mtcars)
mod2 <- stats::lm(mpg ~ disp + hp + wt + drat, data = mtcars)
##The VIF values for each regression model
vifx(mod=mod1)
vifx(mod=mod2)
}
\references{
Salas-Eljatib, C. 2021. Análisis de datos con el programa
estadístico R: una introducción aplicada. Ediciones Universidad
Mayor, Santiago, Chile. 170 p. \url{https://eljatib.com/rlibro}
}
\author{
Christian Salas-Eljatib.
}
