% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describeDataDatana.r
\docType{data}
\name{species2}
\alias{species2}
\title{Información taxonómica de especies vegetales (principalmente árboles)}
\format{
Los datos contienen31 variables (columnas)
\describe{
\item{nesp}{Unique correlative specie number}
\item{spp.ci.name}{Species scientific name}
\item{spp.ci.abb}{Species scientific name abbreviation}
\item{nom.com}{Species common name. No blank spaces,  no special characters}
\item{nom.com.vacio}{Species common name. With blank spaces,  no special
 characters}
\item{esp}{Species code: code given by CEM Biometrics to identify species
 for different processing routines}
\item{nom.com.latex}{Species common name formatted for Latex}
\item{ntaxon}{Unique number of the taxon (i.e., species)}
\item{reino}{Taxonomic rank Kingdom. In this datase, all species belong to
 the Kingdom Plantae}
\item{division}{Taxonomic rank division or phylum within the Kingdom}
\item{clase}{Taxonomic rank Class within the Kingdom}
\item{orden}{Taxonomic rank Order within the Class}
\item{familia}{Taxonomic rank Family within the Order}
\item{spp.ci.comple}{Full scientific name including author}
\item{genero}{Taxonomic rank Genus within the Family}
\item{epiteto}{Specific epithet}
\item{spp.aut}{Species author}
\item{subspp}{Subespecies: one of two or more populations of a species 
varying from one another by morphological characteristics}
\item{subspp.aut}{Subespecies author}
\item{varspp}{Species variety or varietas}
\item{varspp.aut}{Variety author}
\item{formaspp}{Forma de vida de la especie}
\item{formaspp.aut}{Autor que asigno la forma de vida}
\item{nomcom.list}{List of common names per species, separated by commas}
\item{sinonimia}{Sinonimia of the scientific name by which the species has 
been or is known}
\item{pais.limi}{Border countries given the species distribution range}
\item{habito}{Habit. The general appearance, growth form, or architecture 
e.g., tree, shrub, grass}
\item{ciclo.vida}{Life cycle}
\item{estatus.ori}{Status according to the species origin: Native or 
Endemic}
\item{dist.regional}{Distribution range of the species, within Chile
 administrative regions}
\item{rango.alti}{Rango altitudinal, en metros sobre el nivel del mar,
de la especie.}
\item{notas}{Notas}
}
}
\source{
Datos disponibles en \url{https://investigacion.conaf.cl}, con ciertas
 modificaciones (no botanicas) por
 el Laboratorio de Biometría y Modelación Forestal de la Universidad de
  Chile.
}
\usage{
data(species2)
}
\description{
Los datos proveen diferentes características de la clasificación taxonómica 
de especies de plantas.
 Incluye codigos y otros que son especialmente usados en biometría de 
 bosques.
}
\examples{
data(species2)    
table(species2$familia) 
}
\references{
Proyecto 004/2016 Lista sistematica actualizada de la flora vascular nativa 
de Chile, origen y
 distribucion geografica. VII Concurso del Fondo de Investigacion del 
 Bosque Nativo.
}
\keyword{datasets}
