% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{treelistinve2}
\alias{treelistinve2}
\title{Lista de arboles en un inventario forestal.}
\format{
Contiene variables a nivel de arbol dentro de parcelas.
\describe{
  \item{parcela}{Numero de la parcela de muestreo.}
  \item{sup.parce}{Superficie de la parcela, en m2.}
  \item{arbol}{Numero identificador del arbol.}
\item{especie}{Nombre comun de especies como sigue: Olivillo= Aextocicon puncatatum, Tepa= Laureliopsis philippiana, 
Lingue= Persea lingues, Coigue=Nothofagus dombeyi, Roble=Nothofagus obliqua, Other=Other}
\item{dap}{Diametro a la altura del pecho, en cm}
\item{htot}{Altura total, en m. Solo medida en algunas arboles muestra.}
 }
}
\source{
The data are provided courtesy of Prof. Christian Salas-Eljatib (Chile).
}
\usage{
data(treelistinve2)
}
\description{
Variables a nivel de arbol medidos en 3 unidad de muestreo establecidas en un inventario forestal. 
 Note que las parcelas no tienen todas la misma superficie. Las parcelas
 fueron establecidas en un bosque secundario de Nothofagus obliqua en las cercanias de Temuco.
}
\examples{
data(treelistinve2)    
unique(treelistinve2$parcela) 
table(treelistinve2$parcela,treelistinve2$sup.parce)
}
\references{
- Salas C. 2001. Caracterización básica del relicto de Biodiversidad 
Rucamanque. Bosque Nativo, 29:3-9. \url{https://eljatib.com/publication/2001-01-01_caracterizacion_basi/}

- Salas C. 2002. Ajuste y validación de ecuaciones de volumen para un relicto
del bosque de Roble-Laurel-Lingue. Bosque 23(2): 81-92. \url{https://eljatib.com/publication/2002-01-01_ajuste_y_validacion_/}
}
\keyword{datasets}
