% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDDM_A.R
\name{HDDM_A}
\alias{HDDM_A}
\title{HDDM_A: Drift Detection Method based on Adaptive Windows}
\description{
This class implements the HDDM_A drift detection method that uses adaptive windows
to detect changes in the mean of a data stream. It is designed to monitor online streams
of data and can detect increases or decreases in the process mean in a non-parametric and
online manner.
}
\details{
HDDM_A adapts to changes in the data stream by adjusting its internal windows to track
the minimum and maximum values of the process mean. It triggers alerts when a significant
drift from these benchmarks is detected.
}
\examples{
set.seed(123)  # Setting a seed for reproducibility
data_part1 <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.7, 0.3))

# Introduce a change in data distribution
data_part2 <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.3, 0.7))

# Combine the two parts
data_stream <- c(data_part1, data_part2)

# Initialize the hddm_a object
hddm_a_instance <- HDDM_A$new()

# Iterate through the data stream
for(i in seq_along(data_stream)) {
  hddm_a_instance$add_element(data_stream[i])
  if(hddm_a_instance$warning_detected) {
    message(paste("Warning detected at index:", i))
  }
  if(hddm_a_instance$change_detected) {
    message(paste("Concept drift detected at index:", i))
  }
}
}
\references{
Frías-Blanco I, del Campo-Ávila J, Ramos-Jimenez G, et al. Online and non-parametric drift
detection methods based on Hoeffding’s bounds. IEEE Transactions on Knowledge and Data
Engineering, 2014, 27(3): 810-823.

Albert Bifet, Geoff Holmes, Richard Kirkby, Bernhard Pfahringer. MOA: Massive Online Analysis;
Journal of Machine Learning Research 11: 1601-1604, 2010.

Implementation: https://github.com/scikit-multiflow/scikit-multiflow/blob/a7e316d1cc79988a6df40da35312e00f6c4eabb2/src/skmultiflow/drift_detection/hddm_a.py
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{drift_confidence}}{Confidence level for detecting a drift.}

\item{\code{warning_confidence}}{Confidence level for warning detection.}

\item{\code{two_side_option}}{Boolean flag for one-sided or two-sided mean monitoring.}

\item{\code{total_n}}{Total number of samples seen.}

\item{\code{total_c}}{Total cumulative sum of the samples.}

\item{\code{n_max}}{Maximum window end for sample count.}

\item{\code{c_max}}{Maximum window end for cumulative sum.}

\item{\code{n_min}}{Minimum window start for sample count.}

\item{\code{c_min}}{Minimum window start for cumulative sum.}

\item{\code{n_estimation}}{Number of samples since the last detected change.}

\item{\code{c_estimation}}{Cumulative sum since the last detected change.}

\item{\code{change_detected}}{Boolean indicating if a change was detected.}

\item{\code{warning_detected}}{Boolean indicating if a warning has been detected.}

\item{\code{estimation}}{Current estimated mean of the stream.}

\item{\code{delay}}{Current delay since the last update.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HDDM_A-new}{\code{HDDM_A$new()}}
\item \href{#method-HDDM_A-add_element}{\code{HDDM_A$add_element()}}
\item \href{#method-HDDM_A-mean_incr}{\code{HDDM_A$mean_incr()}}
\item \href{#method-HDDM_A-mean_decr}{\code{HDDM_A$mean_decr()}}
\item \href{#method-HDDM_A-reset}{\code{HDDM_A$reset()}}
\item \href{#method-HDDM_A-update_estimations}{\code{HDDM_A$update_estimations()}}
\item \href{#method-HDDM_A-clone}{\code{HDDM_A$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HDDM_A-new"></a>}}
\if{latex}{\out{\hypertarget{method-HDDM_A-new}{}}}
\subsection{Method \code{new()}}{
Initializes the HDDM_A detector with specific settings.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HDDM_A$new(
  drift_confidence = 0.001,
  warning_confidence = 0.005,
  two_side_option = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{drift_confidence}}{Confidence level for drift detection.}

\item{\code{warning_confidence}}{Confidence level for issuing warnings.}

\item{\code{two_side_option}}{Whether to monitor both increases and decreases.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HDDM_A-add_element"></a>}}
\if{latex}{\out{\hypertarget{method-HDDM_A-add_element}{}}}
\subsection{Method \code{add_element()}}{
Adds an element to the data stream and updates the detection status.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HDDM_A$add_element(prediction)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prediction}}{Numeric, the new data value to add.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HDDM_A-mean_incr"></a>}}
\if{latex}{\out{\hypertarget{method-HDDM_A-mean_incr}{}}}
\subsection{Method \code{mean_incr()}}{
Calculates if there is an increase in the mean.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HDDM_A$mean_incr(c_min, n_min, total_c, total_n, confidence)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{c_min}}{Minimum cumulative sum.}

\item{\code{n_min}}{Minimum count of samples.}

\item{\code{total_c}}{Total cumulative sum.}

\item{\code{total_n}}{Total number of samples.}

\item{\code{confidence}}{Confidence threshold for detection.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HDDM_A-mean_decr"></a>}}
\if{latex}{\out{\hypertarget{method-HDDM_A-mean_decr}{}}}
\subsection{Method \code{mean_decr()}}{
Calculates if there is a decrease in the mean.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HDDM_A$mean_decr(c_max, n_max, total_c, total_n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{c_max}}{Maximum cumulative sum.}

\item{\code{n_max}}{Maximum count of samples.}

\item{\code{total_c}}{Total cumulative sum.}

\item{\code{total_n}}{Total number of samples.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HDDM_A-reset"></a>}}
\if{latex}{\out{\hypertarget{method-HDDM_A-reset}{}}}
\subsection{Method \code{reset()}}{
Resets all internal counters and accumulators to their initial state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HDDM_A$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HDDM_A-update_estimations"></a>}}
\if{latex}{\out{\hypertarget{method-HDDM_A-update_estimations}{}}}
\subsection{Method \code{update_estimations()}}{
Updates estimations of the mean after detecting changes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HDDM_A$update_estimations()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HDDM_A-clone"></a>}}
\if{latex}{\out{\hypertarget{method-HDDM_A-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HDDM_A$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
