% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agnostic_aggregate.R
\name{drAggregate}
\alias{drAggregate}
\title{Division-Agnostic Aggregation}
\usage{
drAggregate(data, formula, by = NULL, output = NULL, preTransFn = NULL,
  maxUnique = NULL, params = NULL, packages = NULL, control = NULL)
}
\arguments{
\item{data}{a "ddf" containing the variables in the formula \code{formula}}

\item{formula}{a \code{\link{formula}} object with the cross-classifying variables (separated by +) on the right hand side (or an object which can be coerced to a formula). Interactions are not allowed. On the left hand side, one may optionally give a variable name in the data representing counts; in the latter case, the columns are interpreted as corresponding to the levels of a variable. This is useful if the data have already been tabulated.}

\item{by}{an optional variable name or vector of variable names by which to split up tabulations (i.e. tabulate independently inside of each unique "by" variable value).  The only difference between specifying "by" and placing the variable(s) in the right hand side of the formula is how the computation is done and how the result is returned.}

\item{output}{"kvConnection" object indicating where the output data should reside in the case of \code{by} being specified (see \code{\link{localDiskConn}}, \code{\link{hdfsConn}}).  If \code{NULL} (default), output will be an in-memory "ddo" object.}

\item{preTransFn}{an optional function to apply to each subset prior to performing tabulation.  The output from this function should be a data frame containing variables with names that match that of the formula provided.  Note: this is deprecated - instead use \code{\link{addTransform}} prior to calling divide.}

\item{maxUnique}{the maximum number of unique combinations of variables to obtain tabulations for.  This is meant to help against cases where a variable in the formula has a very large number of levels, to the point that it is not meaningful to tabulate and is too computationally burdonsome.  If \code{NULL}, it is ignored.  If a positive number, only the top and bottom \code{maxUnique} tabulations by frequency are kept.}

\item{params}{a named list of objects external to the input data that are needed in the distributed computing (most should be taken care of automatically such that this is rarely necessary to specify)}

\item{packages}{a vector of R package names that contain functions used in \code{fn} (most should be taken care of automatically such that this is rarely necessary to specify)}

\item{control}{parameters specifying how the backend should handle things (most-likely parameters to \code{rhwatch} in RHIPE) - see \code{\link{rhipeControl}} and \code{\link{localDiskControl}}}
}
\value{
a data frame of the tabulations.  When "by" is specified, it is a ddf with each key-value pair corresponding to a unique "by" value, containing a data frame of tabulations.
}
\description{
Aggregates data by cross-classifying factors, with a formula interface similar to \code{xtabs}
}
\note{
The interface is similar to \code{\link[stats]{xtabs}}, but instead of returning a full contingency table, data is returned in the form of a data frame only with rows for which there were positive counts.  This result is more similar to what is returned by \code{\link{aggregate}}.
}
\examples{
drAggregate(Sepal.Length ~ Species, data = ddf(iris))
}
\author{
Ryan Hafen
}
\seealso{
\code{\link[stats]{xtabs}}, \code{\link{updateAttributes}}
}

