% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{any_obj}
\alias{any_obj}
\title{Validator: Allow any object}
\usage{
any_obj()
}
\value{
A function with the following properties:
\itemize{
\item Always returns TRUE
\item Bypasses any dataclass checks
}
}
\description{
This function is used to bypass dataclass checks for a given element. If you
do not want dataclass to check a given element, set the element equal to
any_obj() to allow any object. Keep in mind that while dataclass will bypass
the check, the object must still be a valid R object. Furthermore, if you
are using dataclass to create a tibble, then the object must be a valid
tibble column type, even if additional checks are not considered. This can be
dangerous because dataclass is designed to check objects, not bypass them.
Use this validator sparingly and consider how you can write a stricter
dataclass.
}
\examples{
# Define a dataclass:
my_dataclass <-
  dataclass(
    date_val = dte_vec(),
    anything = any_obj()
  )

# While `date_val` must be a date, `anything` can be any value!
my_dataclass(
  date_val = as.Date("2022-01-01"),
  anything = lm(vs ~ am, mtcars)
)

my_dataclass(
  date_val = as.Date("2022-01-01"),
  anything = c(1, 2, 3, 4, 5)
)

my_dataclass(
  date_val = as.Date("2022-01-01"),
  anything = list(a = 1, b = 2)
)
}
