% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableType.R
\name{variableType}
\alias{variableType}
\title{Summary function for original class}
\usage{
variableType(v, ...)
}
\arguments{
\item{v}{A variable (vector).}

\item{...}{Not in use.}
}
\value{
An object of class \code{summaryResult} with the following entries:
\code{$feature} ("Variable type"), \code{$result} (the (original) class of
\code{v}) and \code{$value} (identical to \code{$result}).
}
\description{
A \code{\link{summaryFunction}} type function, intended to be called from
\code{\link{summarize}}, which finds the
original class of a variable. This is just the class for all objects but those of class
\code{smartNum}.
}
\examples{
 #For standard variables:
   varX <- c(rep(c(1,2,3), each=10))
   class(varX)
   variableType(varX)

 #For smartNum variables:
   smartX <- dataReporter::smartNum(varX)
   class(smartX)
   variableType(smartX)

}
\seealso{
\code{\link{summarize}}
}
