% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale.R
\name{fastScale}
\alias{fastScale}
\title{scale}
\usage{
fastScale(dataSet, scales = NULL, verbose = TRUE)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{scales}{Result of funcion \code{\link{build_scales}}, (list, default to NULL). \cr
To perform the same scaling on train and test, it is recommended to compute \code{\link{build_scales}}
before. If it is kept to NULL, build_scales will be called.}

\item{verbose}{Should the algorithm talk? (Logical, default to TRUE)}
}
\value{
\code{dataSet} with columns scaled by \strong{reference}. Scaled means that each
 column mean will be 0 and each column standard deviation will be 1.
}
\description{
Perform efficient scaling on a data set.
}
\details{
Scaling numeric values is usefull for some machine learning algorithm such as
 logistic regression or neural networks. \cr
This implementation of scale will be faster that \code{\link{scale}} for large data sets.
}
\examples{
# Load data
data(adult)

# compute scales
scales <- build_scales(adult, cols = "auto", verbose = TRUE)

# Scale data set
adult <- fastScale(adult, scales = scales, verbose = TRUE)

# Control
print(mean(adult$age)) # Almost 0
print(sd(adult$age)) # 1
}
