% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_it.R
\name{save_it}
\alias{save_it}
\title{Save dataset with attributes.}
\usage{
save_it(x, name_of_file)
}
\arguments{
\item{x}{Data.frame. Dataset that has attributes added, including a data dictionary.}

\item{name_of_file}{Text string to name the file.}
}
\value{
This function will save the dataset along with its attributes as an R
dataset (.rds) to the current working directory.
}
\description{
\code{save_it} saves datset with attributes stored as metadata as an R 
dataset (.rds) into the current working directory. This is the final function 
used in this package. For the function to run, the following parameters are needed.
}
\examples{
# example original data set for which a dictionary will be made
data("esoph")
my.data <- esoph

# Linker: Add description for each variable names and variable type
variable_description <- c("age group in years", "alcohol consumption in gm/day", 
"tobacco consumption in gm/day", "number of cases (showing a range)", 
"number of controls (showing range)")

variable_type <- c(0, 0, 0, 0, 0)

linker <- build_linker(my.data = my.data, variable_description = variable_description, 
variable_type = variable_type)
linker

# Data dictionary
# For this data set, no further option description is needed.
dictionary <- build_dict(my.data = my.data, linker = linker, option_description = NULL, 
prompt_varopts = FALSE)
dictionary

# Create main_string for attributes
main_string <- "This dataset describes tobacco and alcohol consumption at different age groups."
complete_dataset <- incorporate_attr(my.data = my.data, data.dictionary = dictionary, 
main_string = main_string)
complete_dataset
attributes(complete_dataset)

# Save it
# Name of file
name_of_file <- "my new data set"
save_it(x = complete_dataset, name_of_file = name_of_file)

}
