% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.diagnostics.hwe.r
\name{gl.diagnostics.hwe}
\alias{gl.diagnostics.hwe}
\title{Provides descriptive stats and plots to diagnose potential problems
  with Hardy-Weinberg proportions}
\usage{
gl.diagnostics.hwe(
  x,
  alpha_val = 0.05,
  bins = 20,
  stdErr = TRUE,
  colors_hist = two_colors,
  colors_barplot = two_colors_contrast,
  plot_theme = theme_dartR(),
  save2tmp = FALSE,
  n.cores = "auto",
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{alpha_val}{Level of significance for testing [default 0.05].}

\item{bins}{Number of bins to display in histograms [default 20].}

\item{stdErr}{Whether standard errors for Fis and Fst should be computed 
(default: TRUE)}

\item{colors_hist}{List of two color names for the borders and fill of the
histogram [default two_colors].}

\item{colors_barplot}{Vector with two color names for the observed and
expected number of significant HWE tests [default two_colors_contrast].}

\item{plot_theme}{User specified theme [default theme_dartR()].}

\item{save2tmp}{If TRUE, saves any ggplots and listings to the session
temporary directory (tempdir) [default FALSE].}

\item{n.cores}{The number of cores to use. If "auto", it will 
use all but one available cores [default "auto"].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default NULL, unless specified using gl.set.verbosity].}
}
\value{
A list with the table with the summary of the HWE tests and (if 
stdErr=TRUE) a named vector with the StdErrFis and StdErrFst.
}
\description{
Different causes may be responsible for lack of Hardy-Weinberg
proportions. This function helps diagnose potential problems.
}
\details{
This function initially runs \code{\link{gl.report.hwe}} and reports
the ternary plots. The remaining outputs follow the recommendations from
 Waples
(2015) paper and De Meeûs 2018. These include: 
\enumerate{ 
\item A histogram
with the distribution of p-values of the HWE tests. The distribution should
be roughly uniform across equal-sized bins. 
\item A bar plot with observed
and expected (null expectation) number of significant HWE tests for the same
locus in multiple populations (that is, the x-axis shows whether a locus
results significant in 1, 2, ..., n populations. The y axis is the count of
these occurrences. The zero value on x-axis shows the number of
non-significant tests). If HWE tests are significant by chance alone,
observed and expected number of HWE tests should have roughly a similar
distribution. 
\item A scatter plot with a linear regression between Fst and Fis,
 averaged across subpopulations. De Meeûs 2018 suggests that in the case of
Null alleles, a strong positive relationship is expected (together with the
Fis standard error much larger than the Fst standard error, see below).
\bold{Note}, this is not the scatter plot that Waples 2015 presents in his
paper. In the lower right corner of the plot, the Pearson correlation
coefficient is reported. 
\item The Fis and Fst (averaged over loci and
subpopulations) standard errors are also printed on screen and reported in
the returned list (if \code{stdErr=TRUE}). These are computed with the 
Jackknife method over loci (See De Meeûs 2007 for details on how this is 
computed) and it may take some time for these computations to complete. 
De Meeûs 2018 suggests that under a global significant heterozygosity 
deficit: 

- if the
correlation between Fis and Fst is strongly positive, and StdErrFis >>
StdErrFst, Null alleles are likely to be the cause. 

- if the correlation
between Fis and Fst is ~0 or mildly positive, and StdErrFis > StdErrFst,
Wahlund may be the cause. 

- if the correlation between Fis and Fst is ~0, and
StdErrFis ~ StdErrFst, selfing or sib mating could to be the cause.

 It is
important to realise that these statistics only suggest a pattern (pointers).
Their absence is not conclusive evidence of the absence of the problem, as 
their presence does not confirm the cause of the problem. 
\item A table where the
number of observed and expected significant HWE tests are reported by each
population, indicating whether these are due to heterozygosity excess or
deficiency. These can be used to have a clue of potential problems (e.g.
deficiency might be due to a Wahlund effect, presence of null alleles or
non-random sampling; excess might be due to sex linkage or different
selection between sexes, demographic changes or small Ne. See Table 1 in
Wapples 2015). The last two columns of the table generated by this function
report chisquare values and their associated p-values. Chisquare is computed
following Fisher's procedure for a global test (Fisher 1970). This basically
tests whether there is at least one test that is truly significant in the
series of tests conducted (De Meeûs et al 2009).
}
}
\examples{
\dontrun{
require("dartR.data")
res <- gl.diagnostics.hwe(x = gl.filter.allna(platypus.gl[,1:50]), 
stdErr=FALSE, n.cores=1)
}
}
\references{
\itemize{ 
\item de Meeûs, T., McCoy, K.D., Prugnolle, F.,
Chevillon, C., Durand, P., Hurtrez-Boussès, S., Renaud, F., 2007. Population
genetics and molecular epidemiology or how to “débusquer la bête”. Infection,
Genetics and Evolution 7, 308-332. 
\item De Meeûs, T., Guégan, J.-F., Teriokhin, A.T., 2009. MultiTest V.1.2, 
a program to binomially combine independent tests and performance comparison 
with other related methods on
proportional data. BMC Bioinformatics 10, 443-443. 
\item De Meeûs, T., 2018. Revisiting FIS, FST, Wahlund Effects, and Null 
Alleles. Journal of Heredity 109, 446-456.
\item Fisher, R., 1970.
Statistical methods for research workers Edinburgh: Oliver and Boyd. 
\item
Waples, R. S. (2015). Testing for Hardy–Weinberg proportions: have we lost
the plot?. Journal of heredity, 106(1), 1-19.
 }
}
\seealso{
\code{\link{gl.report.hwe}}
}
\author{
Custodian: Carlo Pacioni -- Post to
  \url{https://groups.google.com/d/forum/dartr}
}
\concept{reporting functions}
