% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.locmetric.r
\name{gl.report.locmetric}
\alias{gl.report.locmetric}
\title{Report summary of the slot $other$loc.metrics}
\usage{
gl.report.locmetric(x, metric, verbose = NULL)
}
\arguments{
\item{x}{-- name of the genlight object containing the SNP or presence/absence (SilicoDArT) data [required]}

\item{metric}{-- name of the metric to be used for filtering [required]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\value{
returns a tabulation of locmetrics against different thresholds
}
\description{
This script uses any field with numeric values stored in $other$loc.metrics to produce summary statistics (mean, minimum, average, percentiles), histograms and boxplots to assist the decision of choosing thresholds for the filter function gl.filter.locmetric().
The fields that are included in dartR, and a short description, are found below. Optionally, the user can also set his/her own field by adding a vector into $other$loc.metrics as shown in the example. You can check the names of all available loc.metrics via: names(gl$other$loc.metrics).
}
\details{
- SnpPosition - position (zero is position 1) in the sequence tag of the defined SNP variant base 
- CallRate - proportion of samples for which the genotype call is non- missing (that is, not '-' ) 
- OneRatioRef - proportion of samples for which the genotype score is 0 
- OneRatioSnp - proportion of samples for which the genotype score is 2 
- FreqHomRef - proportion of samples homozygous for the Reference allele 
- FreqHomSnp - proportion of samples homozygous for the Alternate (SNP) allele 
- FreqHets - proportion of samples which score as heterozygous, that is, scored as 1 
- PICRef - polymorphism information content (PIC) for the Reference allele 
- PICSnp - polymorphism information content (PIC) for the SNP 
- AvgPIC - average of the polymorphism information content (PIC) of the Reference and SNP alleles 
- AvgCountRef - sum of the tag read counts for all samples, divided by the number of samples with non-zero tag read counts, for the Reference allele row 
- AvgCountSnp - sum of the tag read counts for all samples, divided by the number of samples with non-zero tag read counts, for the Alternate (SNP) allele row 
- RepAvg - proportion of technical replicate assay pairs for which the marker score is consistent 
- rdepth - read depth
}
\examples{
# adding dummy data
test <- testset.gl
test$other$loc.metrics$test <- 1:nLoc(test)
# SNP data
out <- gl.report.locmetric(test,metric="test")

# adding dummy data
test.gs <- testset.gs
test.gs$other$loc.metrics$test <- 1:nLoc(test.gs)
# Tag P/A data
out <- gl.report.locmetric(test.gs,metric="test")
}
\author{
Luis Mijangos (Post to \url{https://groups.google.com/d/forum/dartr})
}
