% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.ibd.r
\name{gl.ibd}
\alias{gl.ibd}
\title{Isolation by distance}
\usage{
gl.ibd(
  gl = NULL,
  Dgen = NULL,
  Dgeo = NULL,
  projected = FALSE,
  permutations = 999,
  plot = TRUE
)
}
\arguments{
\item{gl}{genlight object. If provided a standard analysis on Fst/1-Fst and log(distance) is performed}

\item{Dgen}{genetic distance matrix if no genlight object with coordinates is provided}

\item{Dgeo}{Euclidean distance matrix if no genlight object is provided}

\item{projected}{Switch to indicate that coordinates are already projected (not in lat long) and therefore no projection is carried out. Default is FALSE, so it is assumed coordinates are in lat/longs.}

\item{permutations}{number of permutations in the mantel test}

\item{plot}{should an isolation by distance plot be returned. Default is plot=TRUE}
}
\value{
returns a list of the following components: Dgen (the genetic distance matrix), Dgeo (the Euclidean distance matrix), mantel (the statistics of the mantel test)
}
\description{
This functions performs an isolation by distance analysis based on a mantel test and also produces an isolation by distance plot. If a genlight object with coordinates is provided) then a Euclidean and genetic distance matrix are calculated (currently. Currently only pairwise Fst between population is implemented. Coordinates are expected as lat long and converted to Google Earth Mercator projection. If coordinates are already projected, set projected=TRUE. If such an object is provided an isolation by distance analysis and plot is performed on log(Euclidean distance) against population based pairwise Fst/1-Fst (see  Rousseau's distance measure. Genetics April 1, 1997 vol. 145 no. 4 1219-1228)
You can provide also your own genetic and Euclidean distance matrix. The function is based on the code provided by the adegenet tutorial (\url{http://adegenet.r-forge.r-project.org/files/tutorial-basics.pdf}), using the functions  \link[vegan]{mantel} (package vegan), \link[StAMPP]{stamppFst} (package StAMPP) and Mercator in package dismo.
}
\examples{
\donttest{
ibd <- gl.ibd(bandicoot.gl)
ibd <- gl.ibd(bandicoot.gl,plot = FALSE)
}
}
\references{
Rousset (1997) Genetic Differentiation and Estimation of Gene Flow from F-Statistics Under Isolation by Distancenetics 145(4), 1219-1228.
}
\seealso{
\link[vegan]{mantel}, \link[StAMPP]{stamppFst}
}
\author{
Bernd Gruber (bugs? Post to \url{https://groups.google.com/d/forum/dartr})
}
