% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.allelerich.r
\name{gl.report.allelerich}
\alias{gl.report.allelerich}
\title{Report allelic richness per population from a genlight object}
\usage{
gl.report.allelerich(
  x,
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.dir = NULL,
  plot.file = NULL,
  error.bar = "SD",
  verbose = 2
)
}
\arguments{
\item{x}{A genlight file (works only for diploid data) [required].}

\item{plot.display}{Specify if plot is to be produced [default TRUE].}

\item{plot.theme}{Theme for the plot. See Details for options
[default theme_dartR()].}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()].}

\item{plot.file}{Name for the RDS binary file to save (base name only, 
exclude extension) [default NULL].}

\item{error.bar}{Statistic to be plotted as error bar either "SD" (standard 
deviation) or "SE" (standard error) or "CI" (confidence intervals)
 [default "SD"].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
A dataframe containing richness per site, richness per population, raw reference allele count,
raw alternate allele count.
}
\description{
This function needs package adegenet, please install it.
}
\details{
details
\itemize{
\item raw allele count
\item allelic richness}
}
\examples{
 gl.report.allelerich(possums.gl)
}
\references{
\itemize{
\item El Mousadik, A., & Petit, R. J. (1996). High level of genetic differentiation for allelic richness among populations of the argan tree 
[Argania spinosa (L.) Skeels] endemic to Morocco. Theoretical and applied genetics, 92, 832-839.}
}
\author{
Ching Ching Lau (Post to \url{https://groups.google.com/d/forum/dartr})
}
