% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.subsample.loc.r
\name{gl.subsample.loc}
\alias{gl.subsample.loc}
\title{Subsample loci from a genlight object}
\usage{
gl.subsample.loc(x, n, replace = TRUE, error.check = TRUE, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP or presence/absence
(SilicoDArT) data [required].}

\item{n}{Number of loci to include in the subsample [default NULL]}

\item{replace}{If TRUE, sampling is with replacement [default TRUE]}

\item{error.check}{If TRUE, will undertake error checks on input paramaters [default TRUE]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
 [default NULL, unless specified using gl.set.verbosity]}
}
\value{
Returns the subsampled genlight object
}
\description{
A function to subsample loci at random in a genlight object
with and without replacement.
}
\details{
Retain a subset of loci at random, with or without replacement.
Parameter n must be less than or equal to nLoc(x). 

#' Set error.check = FALSE for speedy execution in simulations
}
\examples{
gl2 <- gl.subsample.loc(testset.gl, n=50, replace=TRUE, verbose=3)
}
\seealso{
Other data manipulation: 
\code{\link{gl.define.pop}()},
\code{\link{gl.drop.ind}()},
\code{\link{gl.drop.loc}()},
\code{\link{gl.drop.pop}()},
\code{\link{gl.edit.recode.pop}()},
\code{\link{gl.impute}()},
\code{\link{gl.join}()},
\code{\link{gl.keep.ind}()},
\code{\link{gl.keep.loc}()},
\code{\link{gl.keep.pop}()},
\code{\link{gl.make.recode.ind}()},
\code{\link{gl.merge.pop}()},
\code{\link{gl.reassign.pop}()},
\code{\link{gl.recode.ind}()},
\code{\link{gl.recode.pop}()},
\code{\link{gl.rename.pop}()},
\code{\link{gl.sample}()},
\code{\link{gl.sim.genotypes}()},
\code{\link{gl.sort}()},
\code{\link{gl.subsample.ind}()}
}
\author{
Custodian: Bernd Gruber (Post to \url{https://groups.google.com/d/forum/dartr})
}
\concept{data manipulation}
