% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/darch.Learn.R
\name{preTrainDArch}
\alias{preTrainDArch}
\title{Pre-trains a \code{\linkS4class{DArch}} network}
\usage{
preTrainDArch(darch, dataSet, dataSetValid = NULL, numEpochs = 1,
  numCD = 1, lastLayer = 0, isClass = F, consecutive = T, ...)
}
\arguments{
\item{darch}{A instance of the class \code{\linkS4class{DArch}}.}

\item{dataSet}{\code{\linkS4class{DataSet}} to be used for training.}

\item{dataSetValid}{\code{\linkS4class{DataSet}} to be used for validation.}

\item{numEpochs}{The number of epochs}

\item{numCD}{The number of CD iterations}

\item{lastLayer}{Numeric indicating after which layer to stop training.}

\item{isClass}{Whether to test pre-trained networks against target data}

\item{consecutive}{Whether to train RBMs consecutively instead of each one
epoch at a time.}

\item{...}{Additional parameters for the function \code{\link{trainRBM}}}
}
\value{
Trained \code{\linkS4class{DArch}} instance
}
\description{
This function pre-trains a \code{\linkS4class{DArch}} network with the 
contrastive divergence method
}
\details{
The function runs for every \code{\linkS4class{RBM}} in the
  attribute \code{rbmList} the training function \code{\link{trainRBM}}
  copies after the training the weights and biases into the corresponding
  layer of the \code{\linkS4class{DArch}} network.
}
\seealso{
\code{\linkS4class{DArch}}, \code{\linkS4class{RBM}}, 
  \code{\link{trainRBM}}
}
\keyword{internal}

