% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_time_anomalies.R
\name{detect_time_anomalies}
\alias{detect_time_anomalies}
\title{Detect time anomalies}
\usage{
detect_time_anomalies(activitylog, anomaly_type = c("both", "negative",
  "zero"), details = TRUE, filter_condition = NULL)
}
\arguments{
\item{activitylog}{The activity log}

\item{anomaly_type}{Type of anomalies that need to be detected (either "negative", "zero" or "both")}

\item{details}{Boolean indicating wheter details of the results need to be shown}

\item{filter_condition}{Condition that is used to extract a subset of the activity log prior to the application of the function}
}
\value{
activitylog containing the rows of the original activity log for which a negative or zero duration is detected, together with the duration value and whether it constitutes a zero or negative duration
}
\description{
Function detecting time anomalies, which can refer to activities with negative or zero duration
}
\examples{
\donttest{
data("hospital_actlog")
detect_time_anomalies(activitylog = hospital_actlog)
}
}
