% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_jags_inits.R
\name{setJAGSInits}
\alias{setJAGSInits}
\title{Set initial values for \code{dalmatian}}
\usage{
setJAGSInits(
  mean.model,
  dispersion.model,
  fixed.mean = NULL,
  fixed.dispersion = NULL,
  y = NULL,
  random.mean = NULL,
  sd.mean = NULL,
  random.dispersion = NULL,
  sd.dispersion = NULL
)
}
\arguments{
\item{mean.model}{Model list specifying the structure of the mean. (list)}

\item{dispersion.model}{Model list specifying the structure of the dispersion. (list)}

\item{fixed.mean}{Initial values for the fixed effects of the mean. (numeric)}

\item{fixed.dispersion}{Initial values for the fixed effects of the dispersion. (numeric)}

\item{y}{Initial values for the true response. This should only be specified if the \code{rounding = TRUE} in the main call to dalmatian.}

\item{random.mean}{Initial values for the random effects of the mean. (numeric)}

\item{sd.mean}{Initial values for the standard deviation of the random effects of the mean. (numeric)}

\item{random.dispersion}{Initial values for the random effects of the dispersion. (numeric}

\item{sd.dispersion}{Initial values for the standard deviation of the random effects of the dispersion. (numeric)}
}
\value{
inits (list)
}
\description{
Set initial values for \code{dalmatian}
}
\details{
Allows the user to set initial values for \code{dalmatian}. Any values
not specified will by initialized by \code{JAGS}.
}
\author{
Simon Bonner
}
