% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render-diff.R
\name{render_diff}
\alias{render_diff}
\title{Render a data diff  to html}
\usage{
render_diff(diff, file = tempfile(fileext = ".html"), view = interactive(),
  fragment = FALSE, pretty = FALSE)
}
\arguments{
\item{diff}{object generated with \code{\link{diff_data}}}

\item{file}{to write to}

\item{view}{\code{TRUE} or \code{FALSE}, if \code{TRUE} render_diff will show the diff
in the browser (only if R is used interactively)}

\item{fragment}{if \code{FALSE} the generated HTML will be a valid HTML document, otherwise it is a HTML fragment}

\item{pretty}{if \code{TRUE} use fancy utf8 characters to make arrows prettier.}
}
\value{
generated html
}
\description{
\code{render_diff} will show a diff in html. When \code{view} is \code{TRUE} \code{render_diff} will show
the result in a browser.
}
\examples{
y <- iris[1:3,]
x <- y

x <- head(x,2) # remove a row
x[1,1] <- 10 # change a value
x$hello <- "world"  # add a column
x$Species <- NULL # remove a column

patch <- diff_data(y, x)
render_diff(patch)

#apply patch
y_patched <- patch_data(y, patch)
}

