% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_estimate_wrapper.R,
%   R/formatting_dm_fits_ids.R
\name{load_fits_ids}
\alias{load_fits_ids}
\alias{print.fits_ids_dm}
\title{Load Estimates of a Fit Procedure}
\usage{
load_fits_ids(
  path = "drift_dm_fits",
  fit_procedure_name = "",
  detailed_info = FALSE,
  check_data = TRUE,
  progress = 2
)

\method{print}{fits_ids_dm}(x, ...)
}
\arguments{
\item{path}{character, a path pointing to a folder or directory
containing the individual model fits.}

\item{fit_procedure_name}{character, an optional name that identifies the
fit procedure that should be loaded}

\item{detailed_info}{logical, controls the amount of information displayed
in case multiple fit procedures were found and the user is prompted to
explicitly choose one}

\item{check_data}{logical, should the data be checked before passing them
back? This checks the observed data and the properties of the model. Default
is \code{TRUE}}

\item{progress}{numerical, indicating if and how progress shall be depicted.
If 0, no progress is shown. If 1, basic infos about the checking progress
is shown. If 2, multiple progressbars are shown. Default is 2.}

\item{x}{an object of type \code{fits_ids_dm}, created when calling
\code{load_fits_ids}}

\item{...}{additional arguments}
}
\value{
For \code{load_fits_ids()}, an object of type \code{fits_ids_dm}, which essentially is
a list with two entries:
\itemize{
\item \code{drift_dm_fit_info}, containing a list of the main arguments when
\link{estimate_model_ids} was originally called, including
a time-stamp.
\item \code{all_fits}, containing a list of all the modified/fitted \code{drift_dm}
objects. The list's entry are named according to the individuals'
identifier (i.e., \code{ID}).
}

For \code{print.fits_ids_dm()}, the supplied \code{fit_ids_dm} object \code{x} (invisible
return).
}
\description{
This function loads the results of a fit procedure where a model was fitted
to multiple individuals (see \link{estimate_model_ids}). It is also the
function that creates an object of type \code{fits_ids_dm}.
}
\details{
with respect to the logic outlined in the details of
\link{estimate_model_ids} on the organization of fit procedures,
\code{path} could either point to a directory with (potentially) multiple fit
routines or to a specific folder with the individual fits. In either case
the intended location is recursively searched for files named
\code{drift_dm_fit_info.rds}.

If the fit procedure was uniquely located, either because only one fit
routine was found in the intended location or because only one
\code{drift_dm_fit_info.rds} contains the optional identifier specified in
\code{fit_procedure_name}, then all individual model fits including the
information \code{fit_procedure_name} are loaded and returned.

In case multiple fit procedures are identified, the user is
prompted with a \link[utils:menu]{utils::menu}, listing information about the possible
candidates. The intended fit procedure can then interactively be chosen
by the user. The amount of displayed information is controlled via
\code{detailed_info}.

The \code{print()} method for objects of type \code{fits_ids_dm} prints out basic
information about the fit procedure name, the fitted model, time of (last)
call, and the number of individual data sets.
}
\examples{
# -------------------------------------------------------------------------
# We stored a fit procedure (matching with the example for
# estimate_model_ids()) within the package to easily access it here.
# -------------------------------------------------------------------------

# get the path to the fit procedures' location
# -> if a user saved fit procedures in their working directory,
#    path_to would just be "drift_dm_fits" (see the default value of path)
path_to <- file.path(
  system.file(package = "dRiftDM"), "drift_dm_fits"
)

# then load all the fits of a fit procedure
all_fits <- load_fits_ids(path = path_to, fit_procedure_name = "example")
print(all_fits)
summary(all_fits)

}
\seealso{
\code{\link[=estimate_model_ids]{estimate_model_ids()}}
}
