% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objClass.R
\name{datapointL2}
\alias{datapointL2}
\title{L2 objective function for validation data point}
\usage{
datapointL2(name, time, value, sigma = 1, attr.name = "validation", condition)
}
\arguments{
\item{name}{character, the name of the prediction, e.g. a state name.}

\item{time}{numeric, the time-point associated to the prediction}

\item{value}{character, the name of the parameter which contains the
prediction value.}

\item{sigma}{numeric, the uncertainty of the introduced test data point}

\item{attr.name}{character. The constraint value is additionally returned in an 
attributed with this name}

\item{condition}{character, the condition for which the prediction is made.}
}
\value{
List of class \code{objlist}, i.e. objective value, gradient and Hessian as list.
}
\description{
L2 objective function for validation data point
}
\details{
Computes the constraint value 
\deqn{\left(\frac{x(t)-\mu}{\sigma}\right)^2}{(pred-p[names(mu)])^2/sigma^2}
and its derivatives with respect to p.
}
\examples{
prediction <- list(a = matrix(c(0, 1), nrow = 1, dimnames = list(NULL, c("time", "A"))))
derivs <- matrix(c(0, 1, 0.1), nrow = 1, dimnames = list(NULL, c("time", "A.A", "A.k1")))
attr(prediction$a, "deriv") <- derivs
p0 <- c(A = 1, k1 = 2)

vali <- datapointL2(name = "A", time = 0, value = "newpoint", sigma = 1, condition = "a")
vali(pars = c(p0, newpoint = 1), env = .GlobalEnv)
}
\seealso{
\link{wrss}, \link{constraintL2}
}
