% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objClass.R
\name{priorL2}
\alias{priorL2}
\title{L2 objective function for prior value}
\usage{
priorL2(mu, lambda = "lambda", attr.name = "prior", condition = NULL)
}
\arguments{
\item{mu}{Named numeric, the prior values}

\item{lambda}{Character of length one. The name of the penalty paramter in \code{p}.}

\item{attr.name}{character. The constraint value is additionally returned in an 
attributed with this name}

\item{condition}{character, the condition for which the constraint should apply. If
\code{NULL}, applies to any condition.}
}
\value{
List of class \code{objlist}, i.e. objective value, gradient and Hessian as list.
}
\description{
As a prior function, it returns derivatives with respect to
the penalty parameter in addition to parameter derivatives.
}
\details{
Computes the constraint value 
\deqn{e^{\lambda} \| p-\mu \|^2}{exp(lambda)*sum((p-mu)^2)}
and its derivatives with respect to p and lambda.
}
\examples{
p <- c(A = 1, B = 2, C = 3, lambda = 0)
mu <- c(A = 0, B = 0)
obj <- priorL2(mu = mu, lambda = "lambda")
obj(pars = p + rnorm(length(p), 0, .1))
}
\seealso{
\link{wrss}
}

