% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objClass.R
\name{constraintL2}
\alias{constraintL2}
\title{Soft L2 constraint on parameters}
\usage{
constraintL2(mu, sigma = 1, attr.name = "prior", condition = NULL)
}
\arguments{
\item{mu}{named numeric, the prior values}

\item{sigma}{named numeric of length of mu or numeric of length one
or character of length of mu or character of length one}

\item{attr.name}{character. The constraint value is additionally returned in an 
attributed with this name}

\item{condition}{character, the condition for which the constraint should apply. If
\code{NULL}, applies to any condition.}
}
\value{
object of class \code{objfn}
}
\description{
Soft L2 constraint on parameters
}
\details{
If sigma is numeric, the function computes the constraint value 
\deqn{\left(\frac{p-\mu}{\sigma}\right)^2}{(p-mu)^2/sigma^2}
and its derivatives with respect to p. If sigma is a character, the 
function computes
\deqn{\left(\frac{p-\mu}{\sigma}\right)^2 + \log(\sigma^2)}{(p-mu)^2/sigma^2 + log(sigma^2)}
and its derivatives with respect to p and sigma. Sigma parameters being
passed to the function are ALWAYS assumed to be on a log scale, i.e. internally
sigma parameters are converted by \code{exp()}.
}
\examples{
mu <- c(A = 0, B = 0)
sigma <- c(A = 0.1, B = 1)
myfn <- constraintL2(mu, sigma)
myfn(pars = c(A = 1, B = -1))

# Introduce sigma parameter but fix them (sigma parameters
# are assumed to be passed on log scale)
mu <- c(A = 0, B = 0)
sigma <- paste("sigma", names(mu), sep = "_")
myfn <- constraintL2(mu, sigma)
pars <- c(A = .8, B = -.3, sigma_A = -1, sigma_B = 1)
myfn(pars = pars[c(1, 3)], fixed = pars[c(2, 4)])

# Assume same sigma parameter for both A and B
# sigma is assumed to be passed on log scale
mu <- c(A = 0, B = 0)
myfn <- constraintL2(mu, sigma = "sigma")
pars <- c(A = .8, B = -.3, sigma = 0)
myfn(pars = pars)

}
\seealso{
\link{wrss}
}

