% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{mstrust}
\alias{mstrust}
\title{Non-Linear Optimization, multi start}
\usage{
mstrust(objfun, center, studyname, rinit = 0.1, rmax = 10, fits = 20,
  cores = 1, samplefun = "rnorm", resultPath = ".", stats = FALSE,
  output = FALSE, ...)
}
\arguments{
\item{objfun}{Objective function, see \code{\link{trust}}.}

\item{center}{Parameter values around which the initial values for each fit 
are randomly sampled. The initial values handed to \link{trust} are the sum
of center and the output of \option{samplefun}, center + 
\option{samplefun}. See \code{\link{trust}}, parinit.
\code{center} Can also be a parframe, then the parameter values are taken 
from the parframe. In this case, the \code{fits} argument is overwritten.}

\item{studyname}{The names of the study or fit. This name is used to 
determine filenames for interim and final results. See Details.}

\item{rinit}{Starting trust region radius, see \code{\link{trust}}.}

\item{rmax}{Maximum allowed trust region radius, see \code{\link{trust}}.}

\item{fits}{Number of fits (jobs).}

\item{cores}{Number of cores for job parallelization.}

\item{samplefun}{Function to sample random initial values. It is assumed, 
that \option{samplefun} has a named parameter "n" which defines how many 
random numbers are to be returned, such as for \code{\link{rnorm}} or 
\code{\link{runif}}. By default \code{\link{rnorm}} is used. Parameteres 
for samplefun are simply appended as named parameters to the mstrust call 
and automatically handed to samplefun by matching parameter names.}

\item{resultPath}{character indicating the folder where the results should 
be stored. Defaults to ".".}

\item{stats}{If true, the same summary statistic as written to the logfile is
printed to command line on mstrust completion.}

\item{output}{logical. If true, writes output to the disc.}

\item{...}{Additional parameters handed to trust(), samplefun(), or the 
objective function by matching parameter names. All unmatched parameters 
are handed to the objective function objfun(). The log file starts with a 
table telling which parameter was assigend to which function.}
}
\value{
A parlist holding errored and converged fits.
}
\description{
Wrapper around \code{\link{trust}} allowing for multiple fits 
  from randomly chosen initial values.
}
\details{
By running multiple fits starting at randomly chosen inital 
  parameters, the chisquare landscape can be explored using a deterministic 
  optimizer. Here, \code{\link{trust}} is used for optimization. The standard
  procedure to obtain random initial values is to sample random variables 
  from a uniform distribution (\code{\link{rnorm}}) and adding these to 
  \option{center}. It is, however, possible, to employ any other sampling 
  strategy by handing the respective function to mstrust(), 
  \option{samplefun}.
  
  In case a special sampling is required, a customized sampling function can 
  be used. If, e.g., inital values leading to a non-physical systems are to 
  be discarded upfront, the objective function can be addapted accordingly.
  
  All started fits either lead to an error or complete converged or
  unconverged. A statistics about the return status of fits can be shown by
  setting \option{stats} to TRUE.
  
  Fit final and intermediat results are stored under \option{studyname}. For
  each run of mstrust for the same study name, a folder under
  \option{studyname} of the form "trial-x-date" is created. "x" is the number
  of the trial, date is the current time stamp. In this folder, the
  intermediate results are stored. These intermediate results can be loaded
  by \code{\link{load.parlist}}. These are removed on successfull completion
  of mstrust. In this case, the final list of fit parameters
  (parameterList.Rda) and the fit log (mstrust.log) are found instead.
}
\seealso{
\code{\link{trust}}, \code{\link{rnorm}}, \code{\link{runif}}, 
  \code{\link{as.parframe}}
}
\author{
Wolfgang Mader, \email{Wolfgang.Mader@fdm.uni-freiburg.de}
}
