% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/prediction.R
\name{Xs}
\alias{Xs}
\title{Model evaluation.}
\usage{
Xs(func, extended, forcings = NULL, events = NULL,
  optionsOde = list(method = "lsoda"), optionsSens = list(method =
  "lsodes"))
}
\arguments{
\item{func}{return value from \code{funC(f)} where \code{f} defines the ODE.}

\item{extended}{return value from \code{funC(c(f, sensitivitiesSymb(f)))}.}

\item{forcings}{data.frame with columns name (factor), time (numeric) and value (numeric).
The ODE forcings.}

\item{events}{data.frame of events with columns "var" (character, the name of the state to be
affected), "time" (numeric, time point), "value" (numeric, value), "method" (character, either
"replace", "add" or "multiply"). See \link[deSolve]{events}.}

\item{optionsOde}{list with arguments to be passed to odeC() for the ODE integration.}

\item{optionsSens}{list with arguments to be passed to odeC() for integration of the extended system}
}
\value{
A model prediction function \code{x(times, pars, forcings, events, deriv = TRUE)} representing
the model evaluation. The result of
\code{x(times, pars, forcings, events, deriv = TRUE)} contains
attributes "sensitivities" and "deriv" with the sensitivities if \code{deriv=TRUE}.
If \code{deriv=FALSE}, sensitivities are not computed (saving time).
If \code{pars} is
the result of \code{p(pouter)} (see \link{P}), the Jacobian of the parameter transformation
and the sensitivities of the ODE are multiplied according to the chain rule for
differentiation. The result is saved in the attributed "deriv",
i.e. in this case the attibutes "deriv" and "sensitivities" do not coincide.
}
\description{
Interface to combine an ODE and its sensitivity equations
into one model function \code{x(times, pars, forcings, events, deriv = TRUE)} returning ODE output and sensitivities.
}

