% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{czso_get_dataset_doc}
\alias{czso_get_dataset_doc}
\title{Get documentation for CZSO dataset}
\usage{
czso_get_dataset_doc(
  dataset_id,
  action = c("return", "open", "download"),
  destfile = NULL,
  format = c("html", "pdf", "word")
)
}
\arguments{
\item{dataset_id}{Dataset ID}

\item{action}{Whether to \code{return} URL (the default), \code{download} the file, or \code{open} the URL in the default web browser.}

\item{destfile}{Where to save the file. Only used if if \code{action = download}.}

\item{format}{What file format to access: \code{html} (the default), \code{pdf}, or \code{word}.}
}
\value{
if \code{action = download}, the path to the downloaded file; file URL otherwise.
}
\description{
Retrieves the URL/downloads the file containing the documentation of the dataset, in the required format.
}
\details{
The document to which this functions provides access contains methodological
background on the specified dataset and is identified by the \code{schema} field
in the list returned by \code{czso_get_dataset_metadata()}.
}
\examples{
\donttest{
czso_get_dataset_doc("110080")
}
}
\seealso{
Other Additional tools: 
\code{\link{czso_get_dataset_metadata}()},
\code{\link{czso_get_table_schema}()}
}
\concept{Additional tools}
