% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_metrics.R
\name{select_metrics}
\alias{select_metrics}
\title{Select columns with evaluation metrics and model definitions}
\usage{
select_metrics(results, include_definitions = TRUE, additional_includes = NULL)
}
\arguments{
\item{results}{Results tibble. E.g. from
\code{\link[cvms:cross_validate]{cross_validate()}} or \code{\link[cvms:evaluate]{evaluate()}}.}

\item{include_definitions}{Whether to include the \code{Dependent},
\code{Fixed} and (possibly) \code{Random} and \code{HParams} columns. (Logical)}

\item{additional_includes}{Names of additional columns to select. (Character)}
}
\value{
The results tibble with only the metric and model definition columns.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("maturing")}

 When reporting results, we might not want all
 the nested tibbles and process information columns.
 This function selects the evaluation metrics and model formulas only.

 If an expected column is not in the \code{results} tibble, it is simply ignored.
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
