% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_manual.R
\name{oc_manual}
\alias{oc_manual}
\title{Set a manual cutpoint for use with cutpointr}
\usage{
oc_manual(cutpoint, ...)
}
\arguments{
\item{cutpoint}{(numeric) The fixed cutpoint.}

\item{...}{To capture further arguments that are always passed to the method
function by cutpointr. The cutpointr function passes data, x, class,
metric_func, direction, pos_class and neg_class to the method function.}
}
\description{
This function simply returns \code{cutpoint} as the optimal cutpoint.
Mainly useful if bootstrap estimates of the out-of-bag performance of a
given cutpoint are desired, e.g. taking a cutpoint value from the literature.
}
\examples{
cutpointr(suicide, dsi, suicide, method = oc_manual, cutpoint = 4)
}
\seealso{
Other method functions: \code{\link{maximize_boot_metric}},
  \code{\link{maximize_gam_metric}},
  \code{\link{maximize_loess_metric}},
  \code{\link{maximize_metric}},
  \code{\link{maximize_spline_metric}},
  \code{\link{oc_mean}}, \code{\link{oc_median}},
  \code{\link{oc_youden_kernel}},
  \code{\link{oc_youden_normal}}
}
\concept{method functions}
