% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_1.R
\name{table_1}
\alias{table_1}
\alias{table_1_dispatcher}
\alias{table_1_summarise}
\alias{table_1_summarize}
\title{Create a Dataset Summary Table (I.E. Table 1)}
\usage{
table_1(.data, key, .vars = vars(everything()), ...)

table_1_dispatcher(.data, var, name, key)

table_1_summarise(.data, var, name, key)

table_1_summarize(.data, var, name, key)
}
\arguments{
\item{.data}{a dataset}

\item{key}{the comparison variable, such as case/control.}

\item{.vars}{a lazy list of variables to include in the description.}

\item{...}{passed on to other methods.}

\item{var}{Variable identifier, used to dispatch}

\item{name}{name of the variable}
}
\value{
The result is a \link[tibble:tibble]{table} which includes:
\itemize{
\item A 'Variable' column, can be renamed with the \code{var.name} argument
}
}
\description{
This helps creates demographics or summary table for a dataset,
the eponymous "table 1".
Given a data set a key for columns,
describe the differences across the provided
factor variables between the levels of key.
}
\details{
\code{table_1_summarise} and \code{table_1_dispatcher} dispatch on the data type of the
variable identified by \code{var} in \code{.data}
}
\examples{
table_1(iris, Species)
table_1(CO2, Plant)

}
