% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inc_beta_deriv.R
\name{inc.beta.deriv}
\alias{inc.beta.deriv}
\title{inc_beta_deriv function}
\usage{
inc.beta.deriv(
  x,
  p = stop("p must be specified"),
  q = stop("q must be specified"),
  err = .Machine$double.eps * 10000,
  minapp = 2,
  maxapp = 1000
)
}
\arguments{
\item{x}{vector of length k containing values to which the beta function is
to be integrated}

\item{p}{Beta shape1 parameter}

\item{q}{Beta shape2 parameter. shape1 and shape2 can be vertors in the same
dimension as x or scalars}

\item{err}{value for error}

\item{minapp}{minimal bound value}

\item{maxapp}{external noud value}
}
\value{
An object of class \code{FD.inc.beta}.
This object is a list containing 15 components. The first 13 components in
the list are each a vector of the same length as x (u in the model). The two
last elements are scalar terms. The output elements are:

\item{I}{\eqn{I_{x,p,q}}. This equal to the output of
\code{pbeta(x,shape1,shape2)}}
\item{Ip}{\eqn{I_{x,p,q}^{p}} denotes the first derivative of the incomplete
beta function with respect to p}
\item{Ipp}{\eqn{I_{x,p,q}^{pp}} denotes the second derivative of the incomplete
beta function with respect to p}
\item{Iq}{\eqn{I_{x,p,q}^{q}} denotes the first derivative of the incomplete
beta function with respect to q}
\item{Iqq}{\eqn{I_{x,p,q}^{qq}} denotes the second derivative of the incomplete
beta function with respect to q}
\item{Ipq}{\eqn{I_{x,p,q}^{pq}} denotes the first derivative of the incomplete
beta function with respect to p and q}
\item{log.Beta}{\eqn{\log[\mathrm{Beta}(p,q)]}}
\item{digamma.p}{\eqn{\psi_p}}
\item{trigamma.p}{\eqn{\psi_p'}}
\item{digamma.q}{\eqn{\psi_q}}
\item{trigamma.q}{\eqn{\psi_q'}}
\item{digamma.pq}{\eqn{\psi_{p+q}}}
\item{trigamma.pq}{\eqn{\psi_{p+q}'}}
\item{nappx}{ highest order approximant evaluated. Iteration stops if
nappx>maxappx}
\item{errapx}{approximate maximum absolute error of computed derivatives}
}
\description{
computes the first and second derivatives of incomplete Beta
function with respect of Beta parameters p and or q using algorithm
differentiating the aproximants of \eqn{I_{x,p,q}} formula in terms of forward
recurrence relations where the the \eqn{n^{th}} approximant can be expressed as :
\deqn{ I_{x,p,q} \approx  K_{x,p,q} A_n/B_n}, \eqn{n \geq 1}

This technique was proposed by Moore (1982) to calculate the derivatives of
incomplete gamma function.
}
\references{
Boik, Robert J., and James F. Robison-Cox. "Derivatives of the
incomplete beta function." Journal of Statistical Software 3.1 (1998): 1-20.
(\href{https://www.jstatsoft.org/htaccess.php?volume=003&type=i&issue=01&filename=paper}{arXiv})
}
\keyword{inc_beta_deriv}
\keyword{internal}
