% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isdiag.R
\name{isdiag}
\alias{isdiag}
\title{Diagnostics for ctsem importance sampling}
\usage{
isdiag(fit)
}
\arguments{
\item{fit}{Output from ctStanFit when optimize=TRUE and isloops > 0}
}
\value{
Nothing. Plots convergence of parameter mean estimates from initial Hessian based distribution to final sampling distribution.
}
\description{
Diagnostics for ctsem importance sampling
}
\examples{
\donttest{
#get data
sunspots<-sunspot.year
sunspots<-sunspots[50: (length(sunspots) - (1988-1924))]
id <- 1
time <- 1749:1924
datalong <- cbind(id, time, sunspots)

#setup model
model <- ctModel(type='stanct', 
 manifestNames='sunspots', 
 latentNames=c('ss_level', 'ss_velocity'),
  LAMBDA=matrix(c( -1, 'ma1 | log(exp(-param)+1)' ), nrow=1, ncol=2),
  DRIFT=matrix(c(0, 'a21', 1, 'a22'), nrow=2, ncol=2),
  MANIFESTMEANS=matrix(c('m1 | (param)*5+44'), nrow=1, ncol=1),
  CINT=matrix(c(0, 0), nrow=2, ncol=1),
  T0VAR=matrix(c(1,0,0,1), nrow=2, ncol=2), #Because single subject
  DIFFUSION=matrix(c(0.0001, 0, 0, "diffusion"), ncol=2, nrow=2))

#fit and plot importance sampling diagnostic
fit <- ctStanFit(datalong, model,verbose=0, 
  optimcontrol=list(is=TRUE, finishsamples=500),priors=TRUE)
isdiag(fit)
}
}
